<?php
/***************************************************************************
 *
 * 	----------------------------------------------------------------------
 * 						DO NOT EDIT THIS FILE
 *	----------------------------------------------------------------------
 * 
 *  				     Copyright (C) Themify
 * 
 *	----------------------------------------------------------------------
 *
 ***************************************************************************/

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/* 	Setting Modules
/***************************************************************************/
	
	///////////////////////////////////////////
	// Site Logo
	///////////////////////////////////////////
	function themify_site_logo( $data = array() ) {
		if($data['attr']['target'] != ''){
			$target = "<span class='hide target'>" . esc_html( $data['attr']['target'] ) . "</span>";
		} else {
			$target = '';
		}
		$data = themify_get_data();
		$text = '';
		$image = '';
		if( isset( $data['setting-site_logo'] ) && 'image' == $data['setting-site_logo'] ) {
			$image = "checked='checked'";
			$image_display = "style='display:block;'";
		} else {
			$text = "checked='checked'";	
			$image_display = "style='display:none;'";
		}
		$logo_image_value = themify_get( 'setting-site_logo_image_value' );
		$logo_image_width = themify_get( 'setting-site_logo_width' );
		$logo_image_height = themify_get( 'setting-site_logo_height' );
		return '<div class="themify_field_row">
					<span class="label">'. __('Display', 'themify') .'</span> 
						<input name="setting-site_logo" type="radio" value="text" '.$text.' /> ' . __('Site Title', 'themify') . '
						<input name="setting-site_logo" type="radio" value="image" '.$image.' /> ' . __('Image', 'themify') . '
					</span>
					'.$target.'
					<div class="uploader-fields image" '.$image_display.'>
						<input type="text" id="setting-site_logo" class="width10" name="setting-site_logo_image_value" value="' . esc_url( $logo_image_value ) . '" />
						<div class="clear image" '.$image_display.'>' . themify_get_uploader('setting-site_logo', array('tomedia' => true)) . '</div>
					</div>
					<span class="pushlabel clear image" '.$image_display.'>
						<input type="text" name="setting-site_logo_width" class="width2" value="' . esc_attr( $logo_image_width ) . '" /> ' . __('width', 'themify') . '
						<input type="text" name="setting-site_logo_height" class="width2" value="' . esc_attr( $logo_image_height ) . '" /> ' . __('height', 'themify') . '
					</span>
				</div>';
	}
	
	///////////////////////////////////////////
	// Favicon Module
	///////////////////////////////////////////
	function themify_favicon( $data = array() ) {
		if($data['attr']['target'] != ''){
			$target = "<span class='hide target'>".$data['attr']['target']."</span>";	
		} else {
			$target = '';
		}
		$setting_favicon = themify_get( 'setting-favicon' );
		return '<div class="themify_field_row">
					<span class="label">'. __('Custom Favicon', 'themify') . '</span>
					<input id="setting-favicon" type="text" class="width10" name="setting-favicon" value="' . esc_attr( $setting_favicon ) . '" /> <br />
					'.$target.'
					<span class="pushlabel" style="display:block;">
						' . themify_get_uploader('setting-favicon', array('tomedia' => true)) . '
					</span>
				</div>';
	}

	///////////////////////////////////////////
	// Favicon Module - Action
	///////////////////////////////////////////
	function themify_favicon_action( $data = array() ) {
		$data = themify_get_data();
		if ( isset( $data['setting-favicon'] ) && $data['setting-favicon'] != '' ) {
			$favurl = themify_https_esc($data['setting-favicon']);
			echo "\n\n".'<link href="' . esc_attr( $favurl ) . '" rel="shortcut icon" /> ';
		}
	}
	add_action('wp_head', 'themify_favicon_action');
	add_action('admin_head', 'themify_favicon_action');
	
	///////////////////////////////////////////
	// Custom Feed URL Module
	///////////////////////////////////////////
	function themify_custom_feed_url( $data = array() ) {
		$custom_feed_url = themify_get( 'setting-custom_feed_url' );
		return '<p><span class="label">' . __( 'Custom Feed URL', 'themify' ) . '</span> <input type="text" class="width10" name="setting-custom_feed_url" value="' . esc_attr( $custom_feed_url ) . '" /> <br />
				<span class="pushlabel"><small>' . __( 'e.g. http://feedburner.com/userid', 'themify' ) . '</small></span></p>';
	}
	
	///////////////////////////////////////////
	// Custom Feed URL Module - Action
	///////////////////////////////////////////
	function themify_custom_feed_url_action( $data = array() ) {
		$data = themify_get_data();
		if( isset( $data['setting-custom_feed_url'] ) && $data['setting-custom_feed_url'] != '' ) {
			echo "\n\n".'<meta name="description" content="'.$data['setting-custom_feed_url'].'" /> ';
		}
	}
	add_action('wp-admin','themify_custom_feed_url_action');
	
	///////////////////////////////////////////
	// Meta Description Module
	///////////////////////////////////////////
	function themify_meta_description( $data = array() ) {
		$data = themify_get_data();
		return '<p><textarea name="setting-meta_description" class="widthfull" rows="4">'.$data['setting-meta_description'].'</textarea></p>';
	}

	/**
	 * Meta Description Module - Action
	 * @param array $data
	 */
	function themify_meta_description_action( $data = array() ) {
		if( $meta_description = themify_get( 'setting-meta_description' ) ) {
			echo "\n\n" . '<meta name="description" content="' . esc_attr( $meta_description ) . '" /> ';
		}
	}
	add_action('wp-admin','themify_meta_description_action');

	/**
	 * Header HTML Module
	 * @param array $data
	 * @return string
	 */
	function themify_header_html( $data = array() ) {
		$header_html = themify_get( 'setting-header_html' );
		return '<p>' . __('The following code will add to the &lt;head&gt; tag.', 'themify') . '</p>
					<p><textarea class="widthfull" rows="10" name="setting-header_html">'.$header_html.'</textarea><br />
					<small>' . __('Useful if you need to add additional scripts such as CSS or JS.', 'themify') . '</small></p>';	
	}

	/**
	 * Header HTML Module - Action
	 * @param array $data
	 */
	function themify_header_html_action( $data = array() ) {
		echo "\n\n" . themify_get( 'setting-header_html' );
	}
	add_action('wp_head','themify_header_html_action');

	/**
	 * Footer HTML Module
	 * @param array $data
	 * @return string
	 */
	function themify_footer_html( $data = array() ) {
		$footer_html = themify_get( 'setting-footer_html' );
		return '<p>' . __('The following code will be added to the footer before the closing &lt;/body&gt; tag.', 'themify') . '</p>
					<p><textarea type="text" class="widthfull" rows="10" name="setting-footer_html">'.$footer_html.'</textarea><br />
					<small>' . __('Useful if you need to Javascript or tracking code.', 'themify') . '</small></p>';
	}

	/**
	 * Footer HTML Module - Action
	 * @param array $data
	 */
	function themify_footer_html_action( $data = array() ) {
		echo "\n\n" . themify_get( 'setting-footer_html' );
	}
	add_action('wp_footer','themify_footer_html_action');

	/**
	 * Custom CSS Module
	 * @param array $data
	 * @return string
	 */
	function themify_custom_css( $data = array() ) {
		$custom_css = themify_get( 'setting-custom_css' );
		return '<p><textarea class="widthfull" rows="35" name="setting-custom_css">'.$custom_css.'</textarea><br /></p>';
	}
	
	///////////////////////////////////////////
	// Search Settings Module
	///////////////////////////////////////////
	function themify_search_settings( $data = array() ) {
		$data            = themify_get_data();
		$post_checked         = '';
		$checked         = '';
		$search_settings = themify_get( 'setting-search_settings' );
		if ( themify_get( 'setting-search_settings_exclude' ) ) {
			$checked = 'checked="checked"';
		}
		if ( themify_get( 'setting-search_exclude_post' ) ) {
			$post_checked = 'checked="checked"';
		}
		$out = '<p>
					<span class="label">' . __( 'Search in Category IDs', 'themify' ) . ' </span>
					<input type="text" class="width6" name="setting-search_settings" value="' . esc_attr( $search_settings ) . '" />
				</p>
				<p>
					<span class="pushlabel"><small>' . __( 'Use minus sign (-) to exclude categories.', 'themify' ) . '</small></span><br />
					<span class="pushlabel"><small>' . __( 'Example: (1,4,-7) = search only in Category 1 &amp; 4, and exclude Category 7.', 'themify' ) . '</small></span>
				</p>
				<p>
					<span class="pushlabel"><label for="setting-search_exclude_post"><input type="checkbox" id="setting-search_exclude_post" name="setting-search_exclude_post" ' . $post_checked . '/> ' . __( 'Exclude Posts in search results', 'themify' ) . '</label></span>
				</p>
				<p>
					<span class="pushlabel"><label for="setting-search_settings_exclude"><input type="checkbox" id="setting-search_settings_exclude" name="setting-search_settings_exclude" ' . $checked . '/> ' . __( 'Exclude Pages in search results', 'themify' ) . '</label></span>
				</p>';


		$pre        = 'setting-search_exclude_';
		$checkboxes = '';

		$exclude_types = apply_filters( 'themify_types_excluded_in_search', get_post_types( array(
			'_builtin'            => false,
			'public'              => true,
			'exclude_from_search' => false
		) ) );

		foreach ( array_keys( $exclude_types ) as $post_type ) {

			$type = get_post_type_object( $post_type );

			if ( is_object( $type ) ) {
				$checkboxes .= '
			<p>
				<span class="pushlabel">
					<label for="' . $pre . $type->name . '">
						<input type="checkbox" id="' . $pre . $type->name . '" name="' . esc_attr( $pre . $type->name ) . '" ' . checked( isset( $data[ $pre . $type->name ] ) ? $data[ $pre . $type->name ] : '', 'on', false ) . '/> ' . sprintf( __( 'Exclude %s in search results', 'themify' ), $type->labels->name ) . '
					</label>
				</span>
			</p>';
			}
		}

		if ( '' != $checkboxes ) {
			$out .= $checkboxes;
		}

		return $out;
	}

if ( ! function_exists( 'themify_search_excludes_cpt' ) ) {
	/**
	 * Exclude Custom Post Types from Search - Filter
	 *
	 * @param $query
	 *
	 * @return mixed
	 */
	function themify_search_excludes_cpt( $query ) {
		if ( ! is_admin() && $query->is_main_query() && $query->is_search ) {

			/////////////////////////////////
			// Set category search settings
			/////////////////////////////////
			$cat_search = themify_get( 'setting-search_settings' );
			if ( isset( $cat_search ) && $cat_search != '' ) {
				$query->set( 'cat', $cat_search );
			}

			//////////////////////////////////
			// Exclude pages & post types ////
			//////////////////////////////////

			// If it's not a product search, proceed: retrieve the post types.
			$types = get_post_types( array( 'exclude_from_search' => false ) );

			// Exclude posts /////////////////
			$exclude_posts = themify_get( 'setting-search_exclude_post' );
			if ( isset( $exclude_posts ) && $exclude_posts ) {
				unset( $types['post'] );
			}

			// Exclude pages /////////////////
			$exclude_pages = themify_get( 'setting-search_settings_exclude' );
			if ( isset( $exclude_pages ) && $exclude_pages ) {
				unset( $types['page'] );
			}

			// Exclude custom post types /////
			$exclude_types = apply_filters( 'themify_types_excluded_in_search', get_post_types( array(
				'_builtin' => false,
				'public' => true,
				'exclude_from_search' => false
			)));

			foreach( array_keys( $exclude_types ) as $type ) {
				$exclude_type = null;
				$exclude_type = themify_get( 'setting-search_exclude_' . $type );
				if ( isset( $exclude_type ) && $exclude_type ) {
					unset( $types[$type] );
				}
			}

			// Section post type is always excluded
			if ( isset( $types['section'] ) ) {
				unset( $types['section'] );
			}

			// Exclude Layout and Layout Part custom post types /////
			unset( $types['tbuilder_layout'] );
			unset( $types['tbuilder_layout_part'] );

			// Search for products
			if ( isset( $query->query_vars['post_type'] ) ) {
				if ( 'post' == $query->query_vars['post_type'] ) {
					unset( $query->query_vars['post_type'] );
					unset( $types['page'] );
					$types[] = 'post';
					if ( ! isset( $exclude_pages ) || ! $exclude_pages ) {
						$types[] = 'page';
					}
				} else {
					$types = array( $query->query_vars['post_type'] );
				}
			}

			// product post_type is excluded when the search is for post post_type
			if ( isset( $_GET['search-option'] ) && $_GET['search-option'] == 'post' ) {
				if ( isset( $types['product'] ) ) {
					unset( $types['product'] );
				}
			}

			// Set final query parameters ////
			$query->set('post_type', $types);
		}
		return $query;
	}
}
add_filter( 'pre_get_posts', 'themify_search_excludes_cpt', 9 );

	///////////////////////////////////////////
	// 404 Page Settings Module
	///////////////////////////////////////////
	if( !function_exists( 'page_404_settings' ) ){
		function page_404_settings(){
			$data            = themify_get_data();
			$page_404 = themify_get( 'setting-page_404' );

			$args = array(
				'sort_order' => 'asc',
				'sort_column' => 'post_title',
				'post_type' => 'page',
				'post_status' => 'publish',
				'posts_per_page' => -1
			);
			$pages = get_posts( $args );
                        $front = get_option('page_on_front');
			$out = '<p>
						<span class="label">' . __( 'Custom 404 Page', 'themify' ) . ' </span>
						<select name="setting-page_404"> 
							<option value="0">'.esc_attr( __( 'Select page', 'themify'  ) ).'</option>';
							foreach ( $pages as $page ) {
                                                            if($page->ID!=$front){
								$selected         = '';
								if ( $page_404 == $page->ID ) {
									$selected = 'selected="selected"';
								}
								$out .= '<option '.$selected.' value="' . esc_attr( $page->ID ) . '">';
								$out .= $page->post_title;
								$out .= '</option>';
                                                            }
							}
				$out .= '</select>
					</p>';
			$out .= '<p>
						<span class="pushlabel"><small>' . __('First create a new Page (eg. 404) and then select it here. The selected page will be used for error 404 (when a URL is not found on your site).', 'themify') . '</small></span>
					</p>';

			return $out;
		}
	}
	
	///////////////////////////////////////////
	// RSS Feed Settings Module
	///////////////////////////////////////////
	function themify_feed_settings( $data = array() ) {
		$checked_use = '';
		$feed_settings = themify_get( 'setting-feed_settings' );
		if ( themify_check( 'setting-exclude_img_rss' ) ) {
			$checked_use = 'checked="checked"';
		}
		return '<p><span class="label">' . __('Feed Category', 'themify') . '</span> <input type="text" class="width6" name="setting-feed_settings" value="' . esc_attr( $feed_settings ) . '" /></p>
				<p>
					<span class="pushlabel"><small>' . __('Use minus sign (-) to exclude categories.', 'themify') . '</small></span><br />
					<span class="pushlabel"><small>' . __('Example: (2,-9) = include only Category 2 in feeds and exclude Category 9.', 'themify') . '</small></span>
				</p>
				<p><span class="label">' . __('Post Image in RSS', 'themify') . '</span> <label for="setting-exclude_img_rss"><input type="checkbox" id="setting-exclude_img_rss" name="setting-exclude_img_rss" '.$checked_use.'/> ' . __('Exclude featured image in RSS feeds', 'themify') . '</label></p>
				<p>
					<span class="pushlabel"><small>' . __('Check this to exclude post image in RSS feeds', 'themify') . '</small></span>
				</p>';
	}
	
	///////////////////////////////////////////
	// RSS Feed Settings Module - Action
	///////////////////////////////////////////
	function themify_feed_settings_action($query){
		$data = themify_get_data();
		if($query->is_feed){
			if(isset($data['setting-feed_settings'])){
				$query->set('cat',$data['setting-feed_settings']);	
			}
		}
		return $query;
	}
	add_filter('pre_get_posts','themify_feed_settings_action');

	///////////////////////////////////////
	// Filter RSS Feed to include post image - Action
	///////////////////////////////////////
	$themify_data = themify_get_data();
	if( !isset($themify_data['setting-exclude_img_rss']) || '' == $themify_data['setting-exclude_img_rss'] ){
		add_filter('the_content', 'themify_custom_fields_for_feeds');

	/* Firefox doesn't render images to feed when select full text from admin > Settings > Reading But IE does automatically for full text.
	 * So this code below will be used by firefox only to render/fetch images in feed. If we use for all then it will show images 2 times. */

		$useragent = isset( $_SERVER['HTTP_USER_AGENT'] ) ? $_SERVER['HTTP_USER_AGENT'] : '';
		if(preg_match('|Firefox/([0-9\.]+)|',$useragent)) {
			add_filter('the_excerpt_rss', 'themify_custom_fields_for_feeds');
			add_filter('the_content_feed', 'themify_custom_fields_for_feeds');
		}

		function themify_custom_fields_for_feeds( $content ) {

			global $post, $id, $themify_check;
			if(!is_feed() || $themify_check == true){
				return $content;
			}

			if(themify_check('post_image')) {
				$content = "<p><img src='" . esc_url( themify_get( 'post_image' ) ) . "'></p>" . $content;
			}
			$themify_check = false;
			return $content;
		}
	}
	
	/**
	 * Outputs Image Script module in theme settings.
	 */
	function themify_img_settings( $data = array() ) {
		$feature_sizes = themify_get_image_sizes_list();
		$checked_use = '';
		if ( themify_check( 'setting-img_settings_use' ) ) {
			$checked_use = "checked='checked'";
		}
		$output = '
		<div class="module">
			<div class="themify-info-link">' . sprintf( __( 'The image script is used to generate featured images dynamically in any dimension. If your images are cropped manually, disable it for faster performance. For more info about the image script, refer to the <a href="%s">Image Script</a> documentation.', 'themify' ), 'http://themify.me/docs/image-script' ) . '
			</div>
			<fieldset>
			<div class="label">' . __( 'Disable', 'themify' ) . '</div> 
			<div class="row">
				<label for="setting-img_settings_use"><input type="checkbox" id="setting-img_settings_use" name="setting-img_settings_use" class="disable_img_php" ' . $checked_use . '/> ' . __( 'Disable image script globally', 'themify' ) . '</label><br/>
				<small class="pushlabel">' . __( 'Default WordPress image sizes or original images will be used.', 'themify' ) . '</small>
				<br/>
			</div>
			<div class="show_if_disabled_img_php">
				<div class="label">' . __('Default Featured Image Size', 'themify') . '</div>
				<div class="show_if_disabled_img_php row">
					<select name="setting-global_feature_size">';
						foreach ( $feature_sizes as $option ) {
							if ( $option['value'] == themify_get( 'setting-global_feature_size' ) ) {
								$output .= '<option value="' . esc_attr( $option['value'] ) . '" selected="selected">';
								$output .= $option['name'];
								$output .= '</option>';
							} else {
								$output .= '<option value="' . esc_attr( $option['value'] ) . '">' . $option['name'] . '</option>';
							}
						}
						$output .= '
					</select>
				</div>
			</div>
			</fieldset>
			
		</div>';
		return $output;
	}

/* 	Styling Modules
/***************************************************************************/	
	
	///////////////////////////////////////////
	// Divider Module
	///////////////////////////////////////////
	function themify_divider( $data = array() ) {
		return '<hr/>';
	}
	
	///////////////////////////////////////////
	// Image Preview Module
	///////////////////////////////////////////
	function themify_image_preview( $data = array() ) {
		global $themify_config;

		//Get currently selected preset
		$savedpath = themify_get( 'styling-'.$data['category'].'-'.$data['id'].'-background_image-value-value' );
		
		//Begin presets block
		$output = '<div class="preset">';

		// If it's activation, delete presets
		if( isset( $_GET['firsttime'] ) && $_GET['firsttime'] ) {
			delete_option('themify_background_presets');
		}

		//Check to see if we have already loaded the presets
		$presets = get_option('themify_background_presets');
		//var_dump($presets);
		if( false == $presets ){
			//if presets were not loaded, create a variable to store them
			$presets = array();

			//Presets first time
			if($data['attr']['src'] != ""){
				$img_folders = array('src' => $data['attr']['src']); 	
			} else {
				$img_folders = $themify_config['folders']['images'];
			}
			if(is_array($img_folders)){
				if(isset($img_folders['src'])){
					$folder = $img_folders['src'];
					if(is_dir(THEME_DIR.'/'.$folder)){
						if($handle = opendir(THEME_DIR.'/'.$folder)) {
							while (false !== ($file = readdir($handle))) {
								$ext = substr(strrchr($file, '.'), 1);
								if($ext == 'jpg' || $ext == 'gif' || $ext == 'png'){
									$fullpath = get_template_directory_uri()."/".$folder.$file;
									$is_selected = trim($fullpath) == trim($savedpath)? 'selected': '';
									$output .= '<a href="#" title="'.$folder.$file.'"><span title="'.$folder.$file.'"></span>
										<img src="' . esc_url( $fullpath ) . '" alt="' . esc_attr( $fullpath ) . '" class="backgroundThumb '.$is_selected.'" /></a>';
									$presets[sanitize_file_name($file)] = $fullpath; 
								}
							}
							closedir($handle);
						}
					}
				} else {
					foreach($img_folders as $folder){
						$folder = $folder['src'];
						if(is_dir(THEME_DIR.'/'.$folder)){
							if($handle = opendir(THEME_DIR.'/'.$folder)) {
								while (false !== ($file = readdir($handle))) {
									$ext = substr(strrchr($file, '.'), 1);
									if($ext == 'jpg' || $ext == 'gif' || $ext == 'png'){
										$fullpath = get_template_directory_uri()."/".$folder.$file;
										$is_selected = trim($fullpath) == trim($savedpath)? 'selected': '';
										$output .= '<a href="#" title="'.$folder.$file.'"><span title="'.$folder.$file.'"></span>
										<img src="' . esc_url( $fullpath ) . '" alt="' . esc_attr( $fullpath ) . '" class="backgroundThumb ' . $is_selected . '" /></a>';
										$output .= '<input type="hidden" name="preset' . sanitize_file_name($file) . '" value="' . esc_attr( $fullpath ) . '" />';
										$presets[sanitize_file_name($file)] = $fullpath;
									}
								}		
								closedir($handle);
							}
						}
					}
				}
			}
			//Presets first time END
			//var_dump($presets); //remove this!
			update_option( 'themify_background_presets', $presets );
		}
		else {
			//we have already stored our presets so go ahead and show them
			foreach ($presets as $file => $fullpath) {
				$is_selected = trim($fullpath) == trim($savedpath)? 'selected': '';
				$output .= '<a href="#" title="' . esc_attr( basename($file) ) . '"><span title="' . esc_attr( $file ) . '"></span><img src="' . esc_url( $fullpath ) . '" alt="' . esc_attr( $fullpath ) . '" class="backgroundThumb ' . $is_selected . '" /></a>';
			}			
		}
		
		//End presets block
		$output .= '</div>';		
		return $output;
	}

	/**
	 * Refresh background presets
	 * @since 1.5.1
	 */
	function themify_delete_background_presets() {
		delete_option('themify_background_presets');
	}
	add_action( 'switch_theme', 'themify_delete_background_presets' );
	
	///////////////////////////////////////////
	// Background Image Module
	///////////////////////////////////////////
	function themify_background_image( $data = array() ) {
		if($data['attr']['target'] != ''){
			$target = "<span class='hide target'>".$data['attr']['target']."</span>";
		} else {
			$target = '';
		}
		$data['value'] = isset( $data['value']['value'] )? $data['value']['value'] : '';
		$data_value = isset( $data['value']['value'] ) ? $data['value']['value'] : '';
		$none_checked = '';
		if ( isset( $data['value'] ) && isset( $data['value']['none'] ) && $data['value']['none'] ) {
			$none_checked = "checked='checked'";
		}
		$output = '<div class="themify_field_row background_image">
						<span class="label">' . __( 'Background Image', 'themify' ) . '</span> 
						'.$target.'
						<input type="text" name="' . esc_attr( 'styling-'.$data['category'].'-'.$data['id'].'-background_image-value-value' ) . '" class="width8 upload-file" id="' . esc_attr( 'styling-'.$data['category'].'-'.$data['id'].'-background_image' ) . '" value="' . esc_attr( $data_value ) . '" />
						<input type="checkbox" class="noBgImage" name="' . esc_attr( 'styling-'.$data['category'].'-'.$data['id'].'-background_image-value-none' ) . '" '.$none_checked.' /> ' . __('No BG image', 'themify') . '<br />
						<div class="pushlabel" style="display:block;">
							'. 
			themify_get_uploader(
				'styling-'.$data['category'].'-'.$data['id'].'-background_image',
				array('preset' => true)
			)
							 . '
						</div>
					</div>';		
		return $output;
	}
	
	///////////////////////////////////////////
	// Background Color Module
	///////////////////////////////////////////
	function themify_background_color( $data = array() ) {
		$data['value'] = isset( $data['value']['value'] )? $data['value']['value'] : '';
		$data_value = isset( $data['value']['value'] ) ? $data['value']['value'] : '';
		if ( isset( $data['value'] ) && isset( $data['value']['transparent'] ) && $data['value']['transparent'] ) {
			$output = '
			<div class="themify_field_row themify_field-background_color">
				<span class="label">' . __('Background Color', 'themify') . '</span>
				<div class="themify_field-color">
					<span class="colorSelect" style=""><span></span></span> <input type="text" disabled name="' . esc_attr( 'styling-' . $data['category'] . '-' . $data['id'] . '-background_color-value-value' ) . '" class="colorSelectInput width4 opacity-7" />
					<input type="button" class="button clearColor" value="' . __('x', 'themify') . '">
					<input type="checkbox" checked="checked" name="' . esc_attr( 'styling-' . $data['category'] . '-' . $data['id'] . '-background_color-value-transparent' ) . '" class="colorTransparent" /> ' . __('Transparent', 'themify') . '
				</div>
			</div>';
		} else {
			$output = '
			<div class="themify_field_row themify_field-background_color">
				<span class="label">' . __( 'Background Color', 'themify' ) . '</span>
				<div class="themify_field-color"> 
					<span class="colorSelect " style="' . esc_attr( "background-color:#$data_value;" ) . '"><span></span></span>
					<input type="text" name="' . esc_attr( 'styling-' . $data['category'] . '-' . $data['id'] . '-background_color-value-value' ) . '" value="' . esc_attr( $data_value ) . '" class="colorSelectInput width4" />
					<input type="button" class="button clearColor" value="' . esc_attr__( 'x', 'themify' ) . '">
					<input type="checkbox" name="' . esc_attr( 'styling-' . $data['category'] . '-' . $data['id'] . '-background_color-value-transparent' ) . '" class="colorTransparent" /> ' . __( 'Transparent', 'themify' ) . '
				</div>
			</div>';
		}
		return $output;
	}
	
	///////////////////////////////////////////
	// Background Repeat Module
	///////////////////////////////////////////
	function themify_background_repeat( $data = array() ) {
		$data['value'] = isset( $data['value']['value'] )? $data['value']['value'] : '';
		$options = array(
				array(
					'value' => 'repeat',
					'name' => __('Repeat', 'themify')
				),
				array(
					'value' => 'repeat-x',
					'name' => __('Repeat X', 'themify')
				),
				array(
					'value' => 'repeat-y',
					'name' => __('Repeat Y', 'themify')
				),
				array(
					'value' => 'no-repeat',
					'name' => __('Do not repeat', 'themify')
				)
			);
		$output = '<p><span class="label">' . __('Background Repeat', 'themify') . '</span>
					<select name="' . esc_attr( 'styling-'.$data['category'].'-'.$data['id'].'-background_repeat-value-value' ) . '"><option> </option>';
		foreach($options as $option){
			$output .= '<option value="' . esc_attr( $option['value'] ) . '" ' . selected( $option['value'], isset( $data['value']['value'] ) ? $data['value']['value'] : '', false ) . '>' . esc_html( $option['name'] ) . '</option>';
		}
		$output .=	'</select></p>';	
		return $output;
	}
	
	///////////////////////////////////////////
	// Background Position Module
	///////////////////////////////////////////
	function themify_background_position( $data = array() ) {
		$data['value'] = isset( $data['value']['value'] )? $data['value']['value'] : '';
		$data_value_x = isset( $data['value']['x'] ) ? $data['value']['x'] : '';
		$data_value_y = isset( $data['value']['y'] ) ? $data['value']['y'] : '';
		$options = array(
				array(
					'value' => 'left',
					'name' => __('Left', 'themify')
				),
				array(
					'value' => 'center',
					'name' => __('Center', 'themify')
				),
				array(
					'value' => 'right',
					'name' => __('Right', 'themify')
				)
			);
		$output = '	<p><span class="label">' . __('Background Position', 'themify') . '</span> 
					<select class="background_position positionX"><option> </option>';
		foreach ( $options as $option ) {
			$output .= '<option value="' . esc_attr( $option['value'] ) . '" ' . selected( $option['value'], $data_value_x, false ) . '>' . esc_html( $option['name'] ) . '</option>';
		}
		$output .= '</select>
					<span class="value" style="display:none;">
						<input type="text" name="' . esc_attr( 'styling-'.$data['category'].'-'.$data['id'].'-background_position-value-x' ) . '" value="' . esc_attr( $data_value_x ) . '" class="valueX">
					</span>';
		
		$options = array(
			array(
				'value' => 'top',
				'name' => __('Top', 'themify')
			),
			array(
				'value' => 'center',
				'name' => __('Center', 'themify')
			),
			array(
				'value' => 'bottom',
				'name' => __('Bottom', 'themify')
			)
		);
		$output .= '<select class="background_position positionY"><option> </option>';
		
		foreach ( $options as $option ) {
			$output .= '<option value="' . esc_attr( $option['value'] ) . '" ' . selected( $option['value'], $data_value_y, false ) . '>' . esc_html( $option['name'] ) . '</option>';
		}
		$output .= '</select>
					<span class="value" style="display:none;">
						<input type="text" name="' . esc_attr( 'styling-'.$data['category'].'-'.$data['id'].'-background_position-value-y' ) . '" value="' . esc_attr( $data_value_y ) . '" class="valueY">
					</span>
					</p>';
					
		return $output;
	}
	
	///////////////////////////////////////////
	// Font Family Module
	///////////////////////////////////////////
	function themify_font_family( $data = array() ) {
		global $themify_gfonts;
		$data['value'] = isset( $data['value']['value'] ) ? $data['value']['value'] : '';
		$fonts = array("Arial, Helvetica, sans-serif",
						"Verdana, Geneva, sans-serif",
						"Georgia, \"Times New Roman\", Times, serif",
						"\"Times New Roman\", Times, serif",
						"Tahoma, Geneva, sans-serif",
						"\"Trebuchet MS\", Arial, Helvetica, sans-serif",
						"Palatino, \"Palatino Linotype\", \"Book Antiqua\", serif",
						"\"Lucida Sans Unicode\", \"Lucida Grande\", sans-serif");

		$output = '<p><span class="label">' . esc_html__( 'Font Family', 'themify' ) . '</span>
					<select class="fontFamily" name="' . esc_attr( 'styling-'.$data['category'].'-'.$data['id'].'-font_family-value-value' ) . '"><option> </option>';
		$output .= '<optgroup label="' . esc_attr__('Web Safe Fonts', 'themify') . '">';
		foreach ( $fonts as $font ) {
			if ( isset( $data['value'] ) && isset( $data['value']['value'] ) && ( $font == $data['value']['value'] ) ) {
				$output .= '<option value=\'' . esc_attr( $font ) . '\' selected="selected">' . esc_html( $font ) . '</option>';
			} else {
				$output .= '<option value=\'' . esc_attr( $font ) . '\'>' . esc_html( $font ) . '</option>';
			}
		}
		$output .= '</optgroup>';

		if ( sizeof( $themify_gfonts ) > 0 ) {
			$output .= '<optgroup label="' . esc_attr__( 'Google Fonts', 'themify' ) . '">';
			foreach ( $themify_gfonts as $font ) {
				$selected = ( isset( $data['value']['value'] ) ) && ( $font['family'] == $data['value']['value'] ) ? ' selected="selected"' : '';
				$output .= '<option value=\'' . esc_attr( $font['family'] ) . '\'' . $selected . '>' . esc_html( $font['family'] ) . '</option>';
			}
			$output .= '</optgroup>';
		}

		$output .= '</select></p>';
		return $output;
	}
	
	///////////////////////////////////////////
	// Font Size Module
	///////////////////////////////////////////
	function themify_font_size( $data = array() ) {
		$data['value'] = isset( $data['value']['value'] ) ? $data['value']['value'] : '';
		$data_value = isset( $data['value']['value'] ) ? $data['value']['value'] : '';
		$options = array( 'px', 'em', '%' );
		$output = '<p><span class="label">' . __( 'Font Size', 'themify' ) . '</span>
					<input type="text" class="width2 valid_num" name="' . esc_attr( 'styling-' . $data['category'] . '-' . $data['id'] . '-font_size-value-value' ) . '" value="' . esc_attr( $data_value ) . '" />
					<select name="' . esc_attr( 'styling-' . $data['category'] . '-' . $data['id'] . '-font_size-value-unit' ) . '"><option> </option>';
		foreach ( $options as $option ) {
			if ( isset( $data['value']['unit'] ) && ( $option == $data['value']['unit'] ) ) {
				$output .= '<option value="' . esc_attr( $option ) . '" selected="selected">' . esc_html( $option ) . '</option>';
			} else {
				$output .= '<option value="' . esc_attr( $option ) . '">' . esc_html( $option ) . '</option>';
			}
		}
		$output .= '</select></p>';

		return $output;
	}
	
	///////////////////////////////////////////
	// Font Weight Module
	///////////////////////////////////////////
	function themify_font_weight( $data = array() ) {
		$data['value'] = isset( $data['value']['value'] ) ? $data['value']['value'] : '';
		$options = array(
			array(
				'value' => 'normal',
				'name'  => __( 'Normal', 'themify' )
			),
			array(
				'value' => 'bold',
				'name'  => __( 'Bold', 'themify' )
			)
		);
		$output = '<p><span class="label">' . __( 'Font Weight', 'themify' ) . '</span> <select name="' . esc_attr( 'styling-' . $data['category'] . '-' . $data['id'] . '-font_weight-value-value' ) . '"><option> </option>';
		foreach ( $options as $option ) {
			if ( isset( $data['value']['value'] ) && ( $option['value'] == $data['value']['value'] ) ) {
				$output .= '<option value="' . esc_attr( $option['value'] ) . '" selected="selected">' . esc_html( $option['name'] ) . '</option>';
			} else {
				$output .= '<option value="' . esc_attr( $option['value'] ) . '">' . esc_html( $option['name'] ) . '</option>';
			}
		}
		$output .= '</select></p>';
		return $output;
	}
	
	///////////////////////////////////////////
	// Font Style Module
	///////////////////////////////////////////
	function themify_font_style( $data = array() ) {
		$data['value'] = isset( $data['value']['value'] ) ? $data['value']['value'] : '';
		$options = array(
			array(
				'value' => 'normal',
				'name' => __('Normal', 'themify')
			),
			array(
				'value' => 'italic',
				'name' => __('Italic', 'themify')
			)
		);
		$output = '<p><span class="label">' . __('Font Style', 'themify') . '</span> <select name="' . esc_attr( 'styling-'.$data['category'].'-'.$data['id'].'-font_style-value-value' ) . '"><option> </option>';
		foreach($options as $option){
			if ( isset( $data['value']['value'] ) && ( $option['value'] == $data['value']['value'] ) ) {
				$output .= '<option value="'.esc_attr( $option['value'] ).'" selected="selected">'.esc_html( $option['name'] ).'</option>';
			} else {
				$output .= '<option value="'.esc_attr( $option['value'] ).'">'.esc_html( $option['name'] ).'</option>';
			}
		}
		$output .= '</select></p>';
		return $output;
	}
	
	///////////////////////////////////////////
	// Font Variant Module
	///////////////////////////////////////////
	function themify_font_variant( $data = array() ) {
		$data['value'] = isset( $data['value']['value'] ) ? $data['value']['value'] : '';
		$options = array(
			array(
				'value' => 'normal',
				'name' => __('Normal', 'themify')
			),
			array(
				'value' => 'small-caps',
				'name' => __('Small Caps', 'themify')
			)
		);
		$output = '<p><span class="label">' . __('Font Variant', 'themify') . '</span> <select name="' . esc_attr( 'styling-'.$data['category'].'-'.$data['id'].'-font_variant-value-value' ) . '"><option> </option>';
		foreach($options as $option){
			if ( isset( $data['value']['value'] ) && ( $option['value'] == $data['value']['value'] ) ) {
				$output .= '<option value="'.esc_attr( $option['value'] ).'" selected="selected">' . esc_html( $option['name'] ) . '</option>';
			} else {
				$output .= '<option value="'.esc_attr( $option['value'] ).'">' . esc_html( $option['name'] ) . '</option>';
			}
		}
		$output .= '</select></p>';
		return $output;
	}
	
	///////////////////////////////////////////
	// Line Height Module
	///////////////////////////////////////////
	function themify_line_height( $data = array() ) {
		$data['value'] = isset( $data['value']['value'] ) ? $data['value']['value'] : '';
		$data_value = isset( $data['value']['value'] ) ? $data['value']['value'] : '';
		$options = array('px','em','%');
		$output = '	<p><span class="label">' . __('Line Height', 'themify') . '</span>
					<input type="text" class="width2 valid_num"  name="' . esc_attr( 'styling-'.$data['category'].'-'.$data['id'].'-line_height-value-value' ) . '" value="' . esc_attr( $data_value ) . '" /><select name="' . esc_attr( 'styling-'.$data['category'].'-'.$data['id'].'-line_height-value-unit' ) . '"><option> </option>';
		foreach($options as $option){
			if ( isset( $data['value']['unit'] ) && ( $option == $data['value']['unit'] ) ) {
				$output .= '<option value="' . esc_attr( $option ) . '" selected="selected">' . esc_html( $option ) . '</option>';
			} else {
				$output .= '<option value="' . esc_attr( $option ) . '">' . esc_html( $option ) . '</option>';
			}
		}
		$output .= '</select></p>';
		return $output;
	}
	
	///////////////////////////////////////////
	// Text Transform Module
	///////////////////////////////////////////
	function themify_text_transform( $data = array() ) {
		$data['value'] = isset( $data['value']['value'] ) ? $data['value']['value'] : '';
		$options = array(
			array(
				'value' => 'capitalize',
				'name' => __('Capitalize', 'themify')
			),
			array(
				'value' => 'uppercase',
				'name' => __('Uppercase', 'themify')
			),
			array(
				'value' => 'lowercase',
				'name' => __('Lowercase', 'themify')
			),
			array(
				'value' => 'none',
				'name' => __('None', 'themify')
			)
		);
		$output = '	<p><span class="label">' . __('Text Transform', 'themify') . '</span> <select name="' . esc_attr( 'styling-'.$data['category'].'-'.$data['id'].'-text_transform-value-value' ) . '"><option> </option>';
		foreach($options as $option){
			if ( isset( $data['value']['value'] ) && ( $option['value'] == $data['value']['value'] ) ) {
				$output .= '<option value="'.esc_attr( $option['value'] ).'" selected="selected">' . esc_html( $option['name'] ) . '</option>';
			} else {
				$output .= '<option value="'.esc_attr( $option['value'] ).'">' . esc_html( $option['name'] ) . '</option>';
			}
		}
		$output .= '</select></p>';
		return $output;
	}
	
	///////////////////////////////////////////
	// Text Decoration Module
	///////////////////////////////////////////
	function themify_text_decoration( $data = array() ) {
		$data['value'] = isset( $data['value']['value'] ) ? $data['value']['value'] : '';
		$options = array(
			array(
				'value' => 'underline',
				'name' => __('Underline', 'themify')
			),
			array(
				'value' => 'overline',
				'name' => __('Overline', 'themify')
			),
			array(
				'value' => 'line-through',
				'name' => __('Line through', 'themify')
			),
			array(
				'value' => 'none',
				'name' => __('None', 'themify')
			)
		);
		$output = '	<p><span class="label">' . __('Text Decoration', 'themify') . '</span> <select name="' . esc_attr( 'styling-'.$data['category'].'-'.$data['id'].'-text_decoration-value-value' ) . '"><option> </option>';
		foreach($options as $option){
			if ( isset( $data['value']['value'] ) && ( $option['value'] == $data['value']['value'] ) ) {
				$output .= '<option value="'.esc_attr( $option['value'] ).'" selected="selected">' . esc_html( $option['name'] ) . '</option>';
			} else {
				$output .= '<option value="'.esc_attr( $option['value'] ).'">' . esc_html( $option['name'] ) . '</option>';
			}
		}
		$output .= '</select></p>';
		return $output;
	}
	
	///////////////////////////////////////////
	// Font Color Module
	///////////////////////////////////////////
	function themify_color( $data = array() ) {
		$data['value'] = isset( $data['value']['value'] ) ? $data['value']['value'] : '';
		$data_value = isset( $data['value']['value'] ) ? $data['value']['value'] : '';
		return '<div class="themify_field_row">
					<span class="label">' . __('Color', 'themify') . '</span>
					<div class="themify_field-color">
						<span class="colorSelect" style="' . esc_attr( 'background:#' . $data_value . ';' ) . '">
							<span></span>
						</span>
						<input type="text" class="colorSelectInput width4" value="' . esc_attr( $data_value ) . '" name="' . esc_attr( 'styling-'.$data['category'].'-'.$data['id'].'-color-value-value' ) . '" />
						<input type="button" class="button clearColor" value="' . __('Clear', 'themify') . '">
					</div>
				</div>';
	}
	
	///////////////////////////////////////////
	// Padding Module
	///////////////////////////////////////////
	function themify_padding( $data = array() ) {
		$individuals = '';
		$checked = '';
		$same = '';
		$data['value'] = isset( $data['value']['value'] ) ? $data['value']['value'] : '';
		$data_value_same = isset( $data['value']['same'] ) ? $data['value']['same'] : '';
		$data_value_top = isset( $data['value']['top'] ) ? $data['value']['top'] : '';
		$data_value_right = isset( $data['value']['right'] ) ? $data['value']['right'] : '';
		$data_value_bottom = isset( $data['value']['bottom'] ) ? $data['value']['bottom'] : '';
		$data_value_left = isset( $data['value']['left'] ) ? $data['value']['left'] : '';
		
		if ( isset( $data['value'] ) && isset( $data['value']['checkbox'] ) && $data['value']['checkbox'] ) {
			$checked = "checked='checked'";
			$individuals = "style='display:none;'";	
		} else {
			$same = "style='display:none;'";
		}
		$output = '<div>
						<p>
							<span class="label">' . __('Padding', 'themify') . '</span>
							<span class="same" '.$same.'>
								<input type="text" class="width2 valid_num" name="' . esc_attr( 'styling-'.$data['category'].'-'.$data['id'].'-padding-value-same' ) . '" value="' . esc_attr( $data_value_same ) . '" /> <small>px</small>
							</span>
							<span class="individuals" '.$individuals.'>
								<input type="text" class="width2 valid_num" name="' . esc_attr( 'styling-'.$data['category'].'-'.$data['id'].'-padding-value-top' ) . '" value="' . esc_attr( $data_value_top ) . '" /> ' . __( 'top', 'themify' ) . '
								<input type="text" class="width2 valid_num" name="' . esc_attr( 'styling-'.$data['category'].'-'.$data['id'].'-padding-value-right' ) . '" value="' . esc_attr( $data_value_right ) . '" /> ' . __( 'right', 'themify' ) . '
								<input type="text" class="width2 valid_num"  name="' . esc_attr( 'styling-'.$data['category'].'-'.$data['id'].'-padding-value-bottom' ) . '" value="' . esc_attr( $data_value_bottom ) . '"/> ' . __( 'bottom', 'themify' ) . '
								<input type="text" class="width2 valid_num" name="' . esc_attr( 'styling-'.$data['category'].'-'.$data['id'].'-padding-value-left' ) . '" value="' . esc_attr( $data_value_left ) . '" /> ' . __( 'left', 'themify' ) . ' <small>(px)</small>
							</span>
						</p>
						<p>
							<span class="pushlabel" style="display:block;">
								<input type="checkbox" name="' . esc_attr( 'styling-'.$data['category'].'-'.$data['id'].'-padding-value-checkbox' ) . '" class="padding-switch" '.$checked.' /> ' . __('Same for all', 'themify') . '
							</span>
						</p>
					</div>';
		return $output;
	}
	
	///////////////////////////////////////////
	// Margin Module
	///////////////////////////////////////////
	function themify_margin( $data = array() ) {
		$data['value'] = isset( $data['value']['value'] ) ? $data['value']['value'] : '';
		$data_value_name = isset( $data['value']['same'] ) ? $data['value']['same'] : '';
		$data_value_top = isset( $data['value']['top'] ) ? $data['value']['top'] : '';
		$data_value_right = isset( $data['value']['right'] ) ? $data['value']['right'] : '';
		$data_value_bottom = isset( $data['value']['bottom'] ) ? $data['value']['bottom'] : '';
		$data_value_left = isset( $data['value']['left'] ) ? $data['value']['left'] : '';
		$individuals = '';
		$checked = '';
		$same = '';
		if ( isset( $data['value'] ) && isset( $data['value']['checkbox'] ) && $data['value']['checkbox'] ) {
			$checked = "checked='checked'";
			$individuals = "style='display:none;'";	
		} else {
			$same = "style='display:none;'";
		}
		$output = '<div>
						<p>
							<span class="label">' . __('Margin', 'themify') . '</span>';
		$output .= '<span class="same" '.$same.'>
						<input type="text" class="width2 valid_num" name="' . esc_attr( 'styling-'.$data['category'].'-'.$data['id'].'-margin-value-same' ) . '" value="' . esc_attr( $data_value_name ) . '" /> <small>px</small>
					</span>
					<span class="individuals" '.$individuals.'>
						<input type="text" class="width2 valid_num" name="' . esc_attr( 'styling-'.$data['category'].'-'.$data['id'].'-margin-value-top' ) . '" value="' . esc_attr( $data_value_top ) . '" /> ' . __( 'top', 'themify' ) . '
						<input type="text" class="width2 valid_num" name="' . esc_attr( 'styling-'.$data['category'].'-'.$data['id'].'-margin-value-right' ) . '" value="' . esc_attr( $data_value_right ) . '" /> ' . __( 'right', 'themify' ) . '
						<input type="text" class="width2 valid_num"  name="' . esc_attr( 'styling-'.$data['category'].'-'.$data['id'].'-margin-value-bottom' ) . '" value="' . esc_attr( $data_value_bottom ) . '"/> ' . __( 'bottom', 'themify' ) . '
						<input type="text" class="width2 valid_num" name="' . esc_attr( 'styling-'.$data['category'].'-'.$data['id'].'-margin-value-left' ) . '" value="' . esc_attr( $data_value_left ) . '" /> ' . __( 'left', 'themify' ) . ' <small>(px)</small>
					</span>
				</p>
				<p>
					<span class="pushlabel" style="display:block;">
						<input type="checkbox" name="' . esc_attr( 'styling-'.$data['category'].'-'.$data['id'].'-margin-value-checkbox' ) . '" '.$checked.' class="margin-switch" /> ' . __('Same for all', 'themify') . '
					</span>
				</p>
			</div>';
		return $output;
	}
	
	///////////////////////////////////////////
	// Height Module
	///////////////////////////////////////////
	function themify_height( $data = array() ) {
		$value = isset( $data['value']['value'] ) ? $data['value']['value'] : '';
		$value['value'] = isset( $value['value'] ) ? $value['value'] : '';
		$value['unit'] = isset( $value['unit'] ) ? $value['unit'] : '';
		
		$options = array('px','em','%');
		$output = '	<p><span class="label">' . __('Height', 'themify') . '</span> 
					<input type="text" class="width2 valid_num" value="' . esc_attr( $value['value'] ) . '" name="' . esc_attr( 'styling-'.$data['category'].'-'.$data['id'].'-height-value-value' ) . '" />
					<select name="' . esc_attr( 'styling-'.$data['category'].'-'.$data['id'].'-height-value-unit' ) . '"><option> </option>';
		foreach($options as $option){
			if($option == $value['unit']){
				$output .= '<option value="' . esc_attr( $option ) . '" selected="selected">' . esc_html( $option ) . '</option>';
			} else {
				$output .= '<option value="' . esc_attr( $option ) . '">' . esc_html( $option ) . '</option>';
			}
		}
		$output .= '</select></p>';
		return $output;
	}
	
	///////////////////////////////////////////
	// Width Module
	///////////////////////////////////////////
	function themify_width( $data = array() ) {
		$data['value'] = isset( $data['value']['value'] ) ? $data['value']['value'] : '';
		$options = array('px','em','%');
		$output = '	<p><span class="label">' . __('Width', 'themify') . '</span> 
					<input type="text" class="width2 valid_num" value="' . esc_attr( $data['value'] ) . '" name="' . esc_attr( 'styling-'.$data['category'].'-'.$data['id'].'-width-value-value' ) . '" />
					<select name="' . esc_attr( 'styling-'.$data['category'].'-'.$data['id'].'-width-value-unit' ) . '"><option> </option>';
		foreach($options as $option){
			if($option == $data['value']['unit']){
				$output .= '<option value="' . esc_attr( $option ) . '" selected="selected">' . esc_html( $option ) . '</option>';
			} else {
				$output .= '<option value="' . esc_attr( $option ) . '">' . esc_html( $option ) . '</option>';
			}
		}
		$output .= '</select></p>';
		return $output;
	}
	
	///////////////////////////////////////////
	// Border Module
	///////////////////////////////////////////
	function themify_border( $data = array() ) {
		$data['value'] = isset( $data['value']['value'] ) ? $data['value']['value'] : '';
		$individuals = '';
		$checked = '';
		$same = '';
		if ( isset( $data['value'] ) && isset( $data['value']['checkbox'] ) && $data['value']['checkbox'] ) {
			$checked = "checked='checked'";
			$individuals = "style='display:none;'";	
		} else {
			$same = "style='display:none;'";
		}
		$options = array(
			array(
				'value' => 'solid',
				'name' => __('Solid', 'themify')
			),
			array(
				'value' => 'dashed',
				'name' => __('Dashed', 'themify')
			),
			array(
				'value' => 'dotted',
				'name' => __('Dotted', 'themify')
			),
			array(
				'value' => 'double',
				'name' => __('Double', 'themify')
			)
		);
		$data_value_same = isset( $data['value']['same'] ) ? $data['value']['same'] : '';
		$data_value_same_color = isset( $data['value']['same_color'] ) ? $data['value']['same_color'] : '';
		$data_value_top_color = isset( $data['value']['top_color'] ) ? $data['value']['top_color'] : '';
		$data_value_top = isset( $data['value']['top'] ) ? $data['value']['top'] : '';
		$data_value_right_color = isset( $data['value']['right_color'] ) ? $data['value']['right_color'] : '';
		$data_value_right = isset( $data['value']['right'] ) ? $data['value']['right'] : '';
		$data_value_bottom_color = isset( $data['value']['bottom_color'] ) ? $data['value']['bottom_color'] : '';
		$data_value_bottom = isset( $data['value']['bottom'] ) ? $data['value']['bottom'] : '';
		$data_value_left_color = isset( $data['value']['left_color'] ) ? $data['value']['left_color'] : '';
		$data_value_left = isset( $data['value']['left'] ) ? $data['value']['left'] : '';
		$output = '<div><p>
						<span class="label">' . __('Border', 'themify') . '</span> 
						<span class="same" '.$same.'>
							<span class="colorSelect" style="' . esc_attr( 'background-color:#' . $data_value_same_color . ';' ). '"><span></span></span>  <input type="text" value="' . esc_attr( $data_value_same_color ) . '" name="' . esc_attr( 'styling-'.$data['category'].'-'.$data['id'].'-border-value-same_color' ) . '" class="width4 colorSelectInput" />
							<input type="text" class="width2 valid_num" value="' . esc_attr( $data_value_same ) . '" name="' . esc_attr( 'styling-'.$data['category'].'-'.$data['id'].'-border-value-same' ) . '" /> <small>px</small>
							<select name="' . esc_attr( 'styling-'.$data['category'].'-'.$data['id'].'-border-value-same_style' ) . '"><option> </option>';
							foreach ( $options as $option ) {
								if ( isset( $data['value']['same_style'] ) && ( $option['value'] == $data['value']['same_style'] ) ) {
									$output .= '<option value="'.esc_attr( $option['value'] ).'" selected="selected">' . esc_html( $option['name'] ) . '</option>';
								} else {
									$output .= '<option value="'.esc_attr( $option['value'] ).'">' . esc_html( $option['name'] ) . '</option>';
								}
							}
		$output .= '		</select>
						</span>
						<span class="individuals" '.$individuals.'>
						<span class="borders">
							<span class="colorSelect" style="' . esc_attr( 'background-color:#' . $data_value_top_color . ';' ). '"><span></span></span> <input type="text" value="' . esc_attr( $data_value_top_color ) . '" name="' . esc_attr( 'styling-'.$data['category'].'-'.$data['id'].'-border-value-top_color' ) . '" class="width4 colorSelectInput" />
							<input type="text" class="width2 valid_num" value="' . esc_attr( $data_value_top ) . '" name="' . esc_attr( 'styling-'.$data['category'].'-'.$data['id'].'-border-value-top' ) . '" /> <small>px</small>
							<select name="' . esc_attr( 'styling-'.$data['category'].'-'.$data['id'].'-border-value-top_style' ) . '"><option> </option>';
							foreach ( $options as $option ) {
								if ( isset( $data['value']['top_style'] ) && ( $option['value'] == $data['value']['top_style'] ) ) {
									$output .= '<option value="'.esc_attr( $option['value'] ).'" selected="selected">' . esc_html( $option['name'] ) . '</option>';
								} else {
									$output .= '<option value="'.esc_attr( $option['value'] ).'">' . esc_html( $option['name'] ) . '</option>';
								}
							}
		$output .= '		</select> ' . __('top', 'themify') . '
						</span>
						<span class="pushlabel borders" style="display:block;">
							<span class="colorSelect" style="' . esc_attr( 'background-color:#' . $data_value_right_color . ';' ). '"><span></span></span> <input type="text" value="' . esc_attr( $data_value_right_color ) . '" name="' . esc_attr( 'styling-'.$data['category'].'-'.$data['id'].'-border-value-right_color' ) . '" class="width4 colorSelectInput" />
							<input type="text" class="width2 valid_num" value="' . esc_attr( $data_value_right ) . '" name="' . esc_attr( 'styling-'.$data['category'].'-'.$data['id'].'-border-value-right' ) . '" /> <small>px</small>
							<select name="' . esc_attr( 'styling-'.$data['category'].'-'.$data['id'].'-border-value-right_style' ) . '"><option> </option>';
							foreach ( $options as $option ) {
								if ( isset( $data['value']['right_style'] ) && ( $option['value'] == $data['value']['right_style'] ) ) {
									$output .= '<option value="'.esc_attr( $option['value'] ).'" selected="selected">' . esc_html( $option['name'] ) . '</option>';
								} else {
									$output .= '<option value="'.esc_attr( $option['value'] ).'">' . esc_html( $option['name'] ) . '</option>';
								}
							}
		$output .= '		</select> ' . __('right', 'themify') . '
						</span>
						<span class="pushlabel borders" style="display:block;">
							<span class="colorSelect" style="' . esc_attr( 'background-color:#' . $data_value_bottom_color . ';' ). '"><span></span></span> <input type="text" value="' . esc_attr( $data_value_bottom_color ) . '" name="' . esc_attr( 'styling-'.$data['category'].'-'.$data['id'].'-border-value-bottom_color' ) . '" class="width4 colorSelectInput" />
							<input type="text" class="width2 valid_num" value="' . esc_attr( $data_value_bottom ) . '" name="' . esc_attr( 'styling-'.$data['category'].'-'.$data['id'].'-border-value-bottom' ) . '" /> <small>px</small>
							<select name="' . esc_attr( 'styling-'.$data['category'].'-'.$data['id'].'-border-value-bottom_style' ) . '"><option> </option>';
							foreach ( $options as $option ) {
								if ( isset( $data['value']['bottom_style'] ) && ( $option['value'] == $data['value']['bottom_style'] ) ) {
									$output .= '<option value="'.esc_attr( $option['value'] ).'" selected="selected">' . esc_html( $option['name'] ) . '</option>';
								} else {
									$output .= '<option value="'.esc_attr( $option['value'] ).'">' . esc_html( $option['name'] ) . '</option>';
								}
							}
		$output .= '		</select> ' . __('bottom', 'themify') . '
						</span>
						<span class="pushlabel borders" style="display:block;">
							<span class="colorSelect" style="' . esc_attr( 'background-color:#' . $data_value_left_color . ';' ). '"><span></span></span> <input type="text" value="' . esc_attr( $data_value_left_color ) . '" name="' . esc_attr( 'styling-'.$data['category'].'-'.$data['id'].'-border-value-left_color' ) . '" class="width4 colorSelectInput" />
							<input type="text" class="width2 valid_num" value="' . esc_attr( $data_value_left ) . '" name="' . esc_attr( 'styling-'.$data['category'].'-'.$data['id'].'-border-value-left' ) . '" /> <small>px</small>
							<select name="' . esc_attr( 'styling-'.$data['category'].'-'.$data['id'].'-border-value-left_style' ) . '"><option> </option>';
							foreach ( $options as $option ) {
								if ( isset( $data['value']['left_style'] ) && ( $option['value'] == $data['value']['left_style'] ) ) {
									$output .= '<option value="'.esc_attr( $option['value'] ).'" selected="selected">' . esc_html( $option['name'] ) . '</option>';
								} else {
									$output .= '<option value="'.esc_attr( $option['value'] ).'">' . esc_html( $option['name'] ) . '</option>';
								}
							}
		$output .= '		</select> ' . __('left', 'themify') . '
						</span>
					</span>
					</p>
					<p>
						<span class="pushlabel" style="display:block;">
							<input type="checkbox" class="border-switch" name="' . esc_attr( 'styling-'.$data['category'].'-'.$data['id'].'-border-value-checkbox' ) . '" '.$checked.' /> ' . __('Same for all', 'themify') . '
						</span>
					</p>
				</div>';				
		return $output;
	}
	
	///////////////////////////////////////////
	// Position Module
	///////////////////////////////////////////
	function themify_position( $data = array() ) {
		$data['value'] = isset( $data['value']['value'] ) ? $data['value']['value'] : '';
		$data_value_position = isset( $data['value']['value'] ) ? $data['value']['value'] : '';
		$data_value_x_value = isset( $data['value']['x_value'] ) ? $data['value']['x_value'] : '';
		$data_value_y_value = isset( $data['value']['y_value'] ) ? $data['value']['y_value'] : '';
		$options = array(
			array(
				'value' => 'static',
				'name' => __('static', 'themify')
			),
			array(
				'value' => 'fixed',
				'name' => __('fixed', 'themify')
			),
			array(
				'value' => 'relative',
				'name' => __('relative', 'themify')
			),
			array(
				'value' => 'absolute',
				'name' => __('absolute', 'themify')
			),
			
		);
		$options_x = array(
			array(
				'value' => 'top',
				'name' => __('top', 'themify')
			),
			array(
				'value' => 'bottom',
				'name' => __('bottom', 'themify')
			),			
		);
		$options_y = array(
			array(
				'value' => 'left',
				'name' => __('left', 'themify')
			),
			array(
				'value' => 'right',
				'name' => __('right', 'themify')
			)
		);
		$display = '';
		if ( $data_value_position != 'fixed' && $data_value_position != 'absolute' ) {
			$display = "style='display:none;'";	
		}
		$output = '	<p><span class="label">' . __('Position', 'themify') . '</span>
					<select name="' . esc_attr( 'styling-'.$data['category'].'-'.$data['id'].'-position-value-value" class="select_position' ) . '"><option> </option>';
		foreach ( $options as $option ) {
			if ( $option['value'] == $data_value_position ) {
				$output .= '<option value="'.esc_attr( $option['value'] ).'" selected="selected">' . esc_html( $option['name'] ) . '</option>';
			} else {
				$output .= '<option value="'.esc_attr( $option['value'] ).'">' . esc_html( $option['name'] ) . '</option>';
			}
		}
		$output .= '</select></p>
					<p class="position_display" '.$display.'>
						<span class="pushlabel" style="display:block;">
						<select name="' . esc_attr( 'styling-'.$data['category'].'-'.$data['id'].'-position-value-x' ) . '"><option> </option>';
						foreach ( $options_x as $option ) {
							if ( isset( $data['value']['x'] ) && ( $option['value'] == $data['value']['x'] ) ) {
								$output .= '<option value="'.esc_attr( $option['value'] ).'" selected="selected">' . esc_html( $option['name'] ) . '</option>';
							} else {
								$output .= '<option value="'.esc_attr( $option['value'] ).'">' . esc_html( $option['name'] ) . '</option>';
							}
						}	
		$output .=	'	</select>
						<input type="text" class="width2 valid_num" value="' . esc_attr( $data_value_x_value ) . '" name="' . esc_attr( 'styling-'.$data['category'].'-'.$data['id'].'-position-value-x_value' ) . '" /> <small>px</small>
						</span>
						<span class="pushlabel" >
						<select name="' . esc_attr( 'styling-'.$data['category'].'-'.$data['id'].'-position-value-y' ) . '"><option> </option>';
						foreach ( $options_y as $option ) {
							if ( isset( $data['value']['y'] ) && ( $option['value'] == $data['value']['y'] ) ) {
								$output .= '<option value="'.esc_attr( $option['value'] ).'" selected="selected">' . esc_html( $option['name'] ) . '</option>';
							} else {
								$output .= '<option value="'.esc_attr( $option['value'] ).'">' . esc_html( $option['name'] ) . '</option>';
							}
						}	
		$output .=	'	</select>
						<input type="text" class="width2 valid_num" value="' . esc_attr( $data_value_y_value ) . '" name="' . esc_attr( 'styling-'.$data['category'].'-'.$data['id'].'-position-value-y_value' ) . '" /> <small>px</small>
						</span>
					</p>';
		return $output;	
	}

/**
 * Outputs module for user to select whether to use a lightbox or not. The lightbox choices can be filtered using the 'themify_lightbox_module_options' filter in a custom-functions.php file.
 * @param array $data
 * @return string
 * @since 1.2.5
 */
function themify_gallery_plugins( $data = array() ) {

	$display_options = apply_filters('themify_lightbox_module_options', array(
		__( 'Magnific (lightbox)', 'themify' ) => 'lightbox',
		__( 'None', 'themify' ) => 'none'
	));

	$gallery_lightbox = themify_get( 'setting-gallery_lightbox' );

	$out = '<p>
				<span class="label">' . __( 'WordPress Gallery', 'themify' ) . ' </span>
				<select class="gallery_lightbox_type" name="setting-gallery_lightbox">';
				foreach ( $display_options as $option => $value ) {
					$out .= '<option value="' . esc_attr( $value ) . '" '.selected( $value? $value: 'lightbox', $gallery_lightbox, false ).'>' . esc_html( $option ) . '</option>';
				}
	$out .= '	</select>
			</p>';
	$out .= '<p>
				<span class="pushlabel"><label for="setting-lightbox_content_images">
					<input type="checkbox" id="setting-lightbox_content_images" name="setting-lightbox_content_images" '. checked( themify_get( 'setting-lightbox_content_images' ), 'on', false ) .'/> ' . __('Apply lightbox to image links (ie. links to jpg, png, and gif will open in lightbox)', 'themify') . '</label>
				</span>
			</p>';
	return $out;
}

/**
 * Template to display a link in Links module, also used when creating a link.
 * @param array $data
 * @return string
 * @since 1.2.7
 */
function themify_add_link_template( $fid, $data = array(), $ajax = false, $type = 'image-icon' ) {
	$pre = 'setting-link_';
	
	$type_name = $pre.'type_'.$fid;
	if ( $ajax ) {
		$type_val = $type;
	} else {
		$type_val = isset($data[$type_name])? $data[$type_name] : 'image-icon';
	}

	$title_name = $pre.'title_'.$fid;
	$title_val = isset($data[$title_name])? $data[$title_name] : '';
	
	$link_name = $pre.'link_'.$fid;
	$link_val = isset($data[$link_name])? $data[$link_name] : '';
	
	$img_name = $pre.'img_'.$fid;
	$img_val = ! isset( $data[$img_name] ) || '' == $data[$img_name]? '' : $data[$img_name];

	$ficon_name = $pre.'ficon_'.$fid;
	$ficon_val = trim( isset($data[$ficon_name])? $data[$ficon_name] : '' );

	$ficolor_name = $pre.'ficolor_'.$fid;
	$ficolor_val = isset($data[$ficolor_name])? $data[$ficolor_name] : '';

	$fibgcolor_name = $pre.'fibgcolor_'.$fid;
	$fibgcolor_val = isset($data[$fibgcolor_name])? $data[$fibgcolor_name] : '';

	/**
	 * TODO: Add appearance checkboxes
	 */

	$out = '<li id="' . esc_attr( $fid ) . '" class="social-link-item ' . esc_attr( $type_val ) . '">';

	$out .= '<div class="social-drag">' . esc_html__('Drag to Sort &#8597;', 'themify') . '</div>';

	$out .= '<input type="hidden" name="' . esc_attr( $type_name ) . '" value="' . esc_attr( trim( $type_val ) ) . '">';

	$out .= '<div class="row">
				<span class="label">' . __( 'Title', 'themify' ) . '</span> <input type="text" name="' . esc_attr( $title_name ) . '" class="width6" value="' . esc_attr( trim($title_val) ) . '">
			</div>
			<!-- /row -->';

	$out .= '<div class="row">
				<span class="label">' . __( 'Link', 'themify' ) . '</span> <input type="text" name="' . esc_attr( $link_name ) . '" class="width10" value="' . esc_attr( trim($link_val) ) . '">
			</div>
			<!-- /row -->';

	if ( 'font-icon' == $type_val ) {

		$out .= '<div class="row">
					<span class="label">' . __( 'Icon', 'themify' ) . '</span>';

		$out .= sprintf('<input type="text" id="%s" name="%s" value="%s" size="55" class="themify_input_field themify_fa %s" /> <a class="button button-secondary hide-if-no-js themify_fa_toggle" href="#" data-target="#%s">%s</a>',
			esc_attr( $ficon_name ), esc_attr( $ficon_name ), esc_attr( $ficon_val ), 'small', esc_attr( $ficon_name ), __( 'Insert Icon', 'themify' ) );

		$out .= '</div>
				<!-- /row -->';

		$out .= '<div class="icon-preview font-icon-preview">
						<i class="' . esc_attr( 'fa ' . $ficon_val ) . '"></i>
					</div>
					<!-- /icon-preview -->';

		$out .= '<div class="themify_field_row">
					<span class="label">' . __('Icon Color', 'themify') . '</span>
					<div class="themify_field-color">
						<span class="colorSelect" style="' . esc_attr( 'background:#' . $ficolor_val . ';' ). '">
							<span></span>
						</span>
						<input type="text" class="colorSelectInput width4" value="' . esc_attr( $ficolor_val ) . '" name="' . esc_attr( $ficolor_name ) . '" />
					</div>
				</div>';

		$out .= '<div class="themify_field_row">
					<span class="label">' . __('Background', 'themify') . '</span>
					<div class="themify_field-color">
						<span class="colorSelect" style="' . esc_attr( 'background:#' . $fibgcolor_val . ';' ). '">
							<span></span>
						</span>
						<input type="text" class="colorSelectInput width4" value="' . esc_attr( $fibgcolor_val ) . '" name="' . esc_attr( $fibgcolor_name ) . '" />
					</div>
				</div>';

	} else {

		$out .= '<div class="row">
					<span class="label">' . __( 'Image', 'themify' ) . '</span>
					<div class="uploader-fields image">
						<input type="text" id="' . esc_attr( $img_name ) . '" name="' . esc_attr( $img_name ) . '" class="width10" value="' . esc_attr( $img_val ) . '">
						<div class="clear image">' . themify_get_uploader( $img_name, array( 'tomedia' => true, 'preview' => true ) ) . '</div>
					</div>
				</div>
				<!-- /row -->';
		$out .= '<div class="icon-preview">
					<img id="' . esc_attr( $img_name . '-preview' ) . '" src="' . esc_url( $img_val ) . '" />
				</div>
				<!-- /icon-preview -->';
	}

	$out .= '<a href="#" class="remove-item" data-removelink="' . esc_attr( $fid ) . '"><i class="ti ti-close"></i></a>
		</li>
		<!-- /social-links-item -->';

	return $out;
}

/**
 * Outputs module to manage links to be shown using the corresponding widget
 * @param array $data
 * @return string
 * @since 1.2.7
 */
function themify_manage_links( $data = array() ) {
	$data = themify_get_data();
	$pre = 'setting-link_';
	$field_hash = isset( $data[$pre.'field_hash'] ) && $data[$pre.'field_hash'] ? $data[$pre.'field_hash'] : 10;
	$start = array();
	for ( $i=0; $i < $field_hash; $i++ ) {
		$start['themify-link-'.$i] = 'themify-link-'.$i;
	}
	//$data[$pre.'field_ids'] = json_encode($start);
	
	if ( json_decode( themify_get( $pre.'field_ids' ) ) ) {
		$field_ids = json_decode( themify_get( $pre.'field_ids' ) );
	} else {
		$field_ids = $start;

		// Image Icons

		$data[$pre.'type_themify-link-0'] = 'image-icon';
		$data[$pre.'type_themify-link-1'] = 'image-icon';
		$data[$pre.'type_themify-link-2'] = 'image-icon';
		$data[$pre.'type_themify-link-3'] = 'image-icon';
		$data[$pre.'type_themify-link-4'] = 'image-icon';

		$data[$pre.'title_themify-link-0'] = 'Twitter';
		$data[$pre.'title_themify-link-1'] = 'Facebook';
		$data[$pre.'title_themify-link-2'] = 'Google+';
		$data[$pre.'title_themify-link-3'] = 'YouTube';
		$data[$pre.'title_themify-link-4'] = 'Pinterest';
		
		$data[$pre.'link_themify-link-0'] = '';
		$data[$pre.'link_themify-link-1'] = '';
		$data[$pre.'link_themify-link-2'] = '';
		$data[$pre.'link_themify-link-3'] = '';
		$data[$pre.'link_themify-link-4'] = '';
		
		$data[$pre.'img_themify-link-0'] = THEMIFY_URI . '/img/social/twitter.png';
		$data[$pre.'img_themify-link-1'] = THEMIFY_URI . '/img/social/facebook.png';
		$data[$pre.'img_themify-link-2'] = THEMIFY_URI . '/img/social/google-plus.png';
		$data[$pre.'img_themify-link-3'] = THEMIFY_URI . '/img/social/youtube.png';
		$data[$pre.'img_themify-link-4'] = THEMIFY_URI . '/img/social/pinterest.png';

		// Font Icons

		$data[$pre.'type_themify-link-5'] = 'font-icon';
		$data[$pre.'type_themify-link-6'] = 'font-icon';
		$data[$pre.'type_themify-link-7'] = 'font-icon';
		$data[$pre.'type_themify-link-8'] = 'font-icon';
		$data[$pre.'type_themify-link-9'] = 'font-icon';

		$data[$pre.'title_themify-link-5'] = 'Twitter';
		$data[$pre.'title_themify-link-6'] = 'Facebook';
		$data[$pre.'title_themify-link-7'] = 'Google+';
		$data[$pre.'title_themify-link-8'] = 'YouTube';
		$data[$pre.'title_themify-link-9'] = 'Pinterest';

		$data[$pre.'link_themify-link-5'] = '';
		$data[$pre.'link_themify-link-6'] = '';
		$data[$pre.'link_themify-link-7'] = '';
		$data[$pre.'link_themify-link-8'] = '';
		$data[$pre.'link_themify-link-9'] = '';

		$data[$pre.'ficon_themify-link-5'] = 'fa-twitter';
		$data[$pre.'ficon_themify-link-6'] = 'fa-facebook';
		$data[$pre.'ficon_themify-link-7'] = 'fa-google-plus';
		$data[$pre.'ficon_themify-link-8'] = 'fa-youtube';
		$data[$pre.'ficon_themify-link-9'] = 'fa-pinterest';

		$data[$pre.'ficolor_themify-link-5'] = '';
		$data[$pre.'ficolor_themify-link-6'] = '';
		$data[$pre.'ficolor_themify-link-7'] = '';
		$data[$pre.'ficolor_themify-link-8'] = '';
		$data[$pre.'ficolor_themify-link-9'] = '';

		$data[$pre.'fibgcolor_themify-link-5'] = '';
		$data[$pre.'fibgcolor_themify-link-6'] = '';
		$data[$pre.'fibgcolor_themify-link-7'] = '';
		$data[$pre.'fibgcolor_themify-link-8'] = '';
		$data[$pre.'fibgcolor_themify-link-9'] = '';
		
		$data = apply_filters('themify_default_social_links', $data);
	}

	$out = '<div class="themify-info-link">' . sprintf( __( 'To display the links: go to Appearance > <a href="%s">Widgets</a> and drop a Themify - Social Links widget in a widget area (<a href="%s">learn more</a>)', 'themify' ), admin_url('widgets.php'), 'http://themify.me/docs/social-media-links') . '</div>';

	$out .= '<div id="social-link-type">';
		// Icon Font
		$out .= '<label for="' . esc_attr( $pre ) . 'font_icon">';
		$out .= '<input ' . checked( isset( $data[$pre.'icon_type'] )? $data[$pre.'icon_type'] : 'font-icon', 'font-icon', false) . ' type="radio" id="' . esc_attr( $pre . 'font_icon' ) . '" name="' . esc_attr( $pre . 'icon_type' ) . '" value="font-icon" data-hide="image-icon" /> ';
		$out .= __( 'Icon Font', 'themify' ) . '</label>';

		// Image
		$out .= '<label for="' . esc_attr( $pre ) . 'image_icon">';
		$out .= '<input ' . checked( isset( $data[$pre.'icon_type'] )? $data[$pre.'icon_type'] : '', 'image-icon', false ) . ' type="radio" id="' . esc_attr( $pre . 'image_icon' ) . '" name="' . esc_attr( $pre . 'icon_type' ) . '" value="image-icon" data-hide="font-icon" /> ';
		$out .= __( 'Image', 'themify' ) . '</label>';
	$out .= '</p>';

	$out .=  '<ul id="social-links-wrapper">';
		foreach ( $field_ids as $key => $fid ) {
			$out .= themify_add_link_template( $fid, $data );
		}
	$out .= '</ul>';
	
	$out .= '<p class="add-link add-social-link"><a href="#">' . __('Add Link', 'themify') . '</a></p>';

	$out .= '<input type="hidden" id="' . esc_attr( $pre . 'field_ids' ) . '" name="' . esc_attr( $pre . 'field_ids' ) . '" value=\'' . json_encode( $field_ids ) . '\'/>';
	$out .= '<input type="hidden" id="' . esc_attr( $pre . 'field_hash' ) . '" name="' . esc_attr( $pre . 'field_hash' ) . '" value="' . esc_attr( $field_hash ) . '"/>';
	//$out .= '<p>Fields: '.json_encode($field_ids).'</p><p>Hash: '.$field_hash.'</p>';
	
	return $out;
}

/**
 * Disables Open Graph tags. This function does nothing. It's merely kept so users that might have erroneously customized the theme-config.php copying it and directing it to a new file don't get their sites broken.
 * @deprecated 1.7.5
 * @param array $data
 * @return string $out Markup for option
 */
function themify_open_graph_options($data = array()){
	return '';
}

/**
 * Outputs post meta options
 * @param string $pmkey Key used to get data from theme settings array
 * @param array $data Theme settings data
 * @param array $metas Optional array stating the metas available.
 * @return string $out Markup for options
 */
function themify_post_meta_options( $pmkey, $data, $metas = array(), $states = array(), $group_label = false ) {
	
	if ( empty($metas ) ) {
		$metas = array (
			''			=> __( 'Hide All', 'themify' ),
	 		'author' 	=> __( 'Author', 'themify' ),
	 		'category' 	=> __( 'Category', 'themify' ),
	 		'comment' 	=> __( 'Comment', 'themify' ),
	 		'tag' 		=> __( 'Tag', 'themify' )
		);
	}
	if ( empty( $states ) ) {
		$states = array(
			array(
				'name' => __( 'Hide', 'themify' ),
				'value' => 'yes',
				'icon' => THEMIFY_URI . '/img/ddbtn-check.png',
				'title' => __( 'Hide this meta', 'themify' )
			),
			array(
				'name' => __( 'Do not hide', 'themify' ),
				'value' => 'no',
				'icon' => THEMIFY_URI . '/img/ddbtn-cross.png',
				'title' => __( 'Show this meta', 'themify' )
			)
		);
	}
	if ( ! $group_label ) {
		$group_label = __( 'Hide Post Meta', 'themify' );
	}
	
	$default = array(
		'name' => __( 'Theme', 'themify' ),
		'value' => '',
		'icon' => THEMIFY_URI . '/img/ddbtn-blank.png',
		'title' => __( 'Use theme settings', 'themify' )
	);
	
	$out = '<div class="themify_field_row dropdownbutton-group"><span class="label">' . esc_html( $group_label ) . '</span>';
					
			foreach ( $metas as $meta => $name ) {
				if ( '' == $meta ) {
					$metakey = $pmkey;
					$meta_class = 'ddbtn-all';
				} else {
					$metakey = $pmkey.'_'.$meta;
					$meta_class = 'ddbtn-sub ddbtn-'.$meta;
				}

				$others = '';
				$out .=	'
				<div id="' . esc_attr( $metakey ) . '" class="dropdownbutton-list" data-name="' . esc_attr( $name ) . '" data-def-icon="' . esc_url( $default['icon'] ) . '">';
				
				// default state
				$first = '
					<div class="first-ddbtn">
						<a href="#" data-val="' . esc_attr( $default['value'] ) . '" data-name="' . esc_attr( $default['name'] ) . '" title="' . esc_attr( $default['title'] ) . '">
							<img src="' . esc_url( $default['icon'] ) . '" title="' . esc_attr( $default['title'] ) . '" />
							<span class="ddbtn-name">' . esc_html( $name ) . '</span>
						</a>
					</div>';

				foreach ( $states as $state ) {
					if ( isset( $state['value'] ) && isset( $data[$metakey] ) && $state['value'] == $data[$metakey] ) {
						$first = '
						<div class="first-ddbtn">
							<a href="#" data-val="' . esc_attr( $state['value'] ) . '" data-name="' . esc_attr( $state['name'] ) . '" title="' . esc_attr( $state['title'] ) . '">
								<img src="' . esc_url( $state['icon'] ) . '" title="' . esc_attr( $state['title'] ) . '" />
								<span class="ddbtn-name">' . esc_html( $name ) . '</span>
							</a>
						</div>';
						$selected = 'selected';
						//$hide = 'ddbtn-hide';
						$hide = '';
					} else {
						$selected = '';
						$hide = '';
					}
					
					$others .= '
						<div class="' . esc_attr( 'ddbtn ' . $hide ) . '">
							<a href="#" data-sel="' . esc_attr( $selected ) . '" data-val="' . esc_attr( $state['value'] ) . '" data-name="' . esc_attr( $state['name'] ) . '" title="' . esc_attr( $state['title'] ) . '">
								<img src="' . esc_url( $state['icon'] ) . '" title="' . esc_attr( $state['title'] ) . '" />
								<span class="ddbtn-label">' . esc_html( $state['name'] ) . '</span>
							</a>
						</div>';
				}
				$out .= $first . '<div class="dropdownbutton">' . $others . '</div>';
				$out .= '
				</div>';
				$meta_key_data = themify_get( $metakey );
				$out .= '<input type="hidden" value="' . esc_attr( $meta_key_data ) . '" class="' . esc_attr( $meta_class ) . '" id="' . esc_attr( $metakey ) . '" name="' . esc_attr( $metakey ) . '" />';
			}

	$out .= '</div>';
	return $out;
}

/**
 * Outputs post sorting options
 * @param string $key Key used to get data from theme settings array
 * @param array $data Theme settings data
 * @return string $out Markup for options
 */
if ( ! function_exists( 'themify_post_sorting_options' ) ) {
	function themify_post_sorting_options( $key = 'setting-index_order', $data ) {

		$orderby = themify_get( $key . 'by' );
		$orderby_options = apply_filters( 'themify_index_orderby_options', array(
			__( 'Date (default)', 'themify' ) => 'date',
			__( 'Random', 'themify' ) => 'rand',
			__( 'Author', 'themify' ) => 'author',
			__( 'Post Title', 'themify' ) => 'title',
			__( 'Comments Number', 'themify' ) => 'comment_count',
			__( 'Modified Date', 'themify' ) => 'modified',
			__( 'Post Slug', 'themify' ) => 'name',
			__( 'Post ID', 'themify' ) => 'ID' ) );

		$order = themify_get( $key );
		$order_options = array(
			__( 'Descending (default)', 'themify' ) => 'DESC',
			__( 'Ascending', 'themify' ) => 'ASC' );

		$out = '<p>
					<span class="label">' . __( 'Order By', 'themify' ) . ' </span>
					<select name="' . esc_attr( $key . 'by' ) . '">';
						foreach ( $orderby_options as $option => $value ) {
							$out .= '<option value="' . esc_attr( $value ) . '" '.selected( $value? $value: 'date', $orderby, false ).'>' . esc_html( $option ) . '</option>';
							}
		$out .= '	</select>
				</p>
				<p>
					<span class="label">' . __( 'Order', 'themify' ) . ' </span>
					<select name="' . esc_attr( $key ) . '">';
						foreach ( $order_options as $option => $value ) {
							$out .= '<option value="' . esc_attr( $value ) . '" '.selected( $value? $value: 'DESC', $order, false ).'>' . esc_html( $option ) . '</option>';
					}
		$out .= '	</select>
				</p>';

		return $out;
	}
}

if ( ! function_exists( 'themify_homepage_welcome' ) ) {
	/**
	 * Homepage Welcome Function
	 * @return string Markup for welcome text control
	 */
	function themify_homepage_welcome() {
		return '<p><textarea class="widthfull" name="setting-homepage_welcome" rows="4">' . esc_textarea( themify_get( 'setting-homepage_welcome' ) ) . '</textarea></p>';
	}
}

if ( ! function_exists( 'themify_exclude_rss' ) ) {
	/**
	 * Exclude RSS
	 * @return string
	 */
	function themify_exclude_rss() {
		return '<p><label for="setting-exclude_rss"><input type="checkbox" id="setting-exclude_rss" name="setting-exclude_rss" ' . checked( themify_get( 'setting-exclude_rss' ), 'on', false ) . '/> ' . __( 'Check here to exclude RSS icon/button in the header', 'themify' ) . '</label></p>';	
	}
}

if ( ! function_exists( 'themify_exclude_search_form' ) ) {
	/**
	 * Exclude Search Form
	 * @return string
	 */
	function themify_exclude_search_form() {
		return '<p><label for="setting-exclude_search_form"><input type="checkbox" id="setting-exclude_search_form" name="setting-exclude_search_form" ' . checked( themify_get( 'setting-exclude_search_form' ), 'on', false ) . '/> ' . __( 'Check here to exclude search form in the header', 'themify' ) . '</label></p>';	
	}
}

if ( ! function_exists( 'themify_footer_text_left' ) ) {
	/**
	 * Footer Text Left Function
	 * @return string
	 */
	function themify_footer_text_left() {
		return '<p><textarea class="widthfull" rows="4" name="setting-footer_text_left">' . esc_textarea( themify_get( 'setting-footer_text_left' ) ) . '</textarea></p>';
	}
}

if ( ! function_exists( 'themify_footer_text_right' ) ) {
	/**
	 * Footer Text Right Function
	 * @return string
	 */
	function themify_footer_text_right(){
		return '<p><textarea class="widthfull" rows="4" name="setting-footer_text_right">' . esc_textarea( themify_get( 'setting-footer_text_right' ) ) . '</textarea></p>
		<div class="themify-info-link">' . __( 'Enter your text to replace the copyright and credit links in the footer. HTML tags allowed. Enter an empty space will remove the text.', 'themify' ) . '</div>';
	}
}

if(!function_exists('themify_homepage_widgets')){
	/**
	 * Widgets module function
	 * @return string Module markup
	 */
	function themify_homepage_widgets(){
		$data = themify_get_data();
		$val = isset($data['setting-homepage_widgets'])? $data['setting-homepage_widgets'] : null;
		$options = array(
			array(
				'value' => 'homewidget-4col',
				'img' => 'themify/img/sidebars/4col.png',
				'title' => __('Widgets 4 Columns', 'themify')),
			array(
				'value' => 'homewidget-3col',
				'img' => 'themify/img/sidebars/3col.png',
				'title' => __('Widgets 3 Columns', 'themify'),
				'selected' => true),
			array(
				'value' => 'homewidget-2col',
				'img' => 'themify/img/sidebars/2col.png',
				'title' => __('Widgets 3 Columns', 'themify')),
			array(
				'value' => 'homewidget-1col',
				'img' => 'themify/img/sidebars/1col.png',
				'title' => __('Widgets 1 Column', 'themify')),
			array(
				'value' => 'none',
				'img' => 'themify/img/sidebars/none.png',
				'title' => __('No Widgets', 'themify'))
		);
		$output = '';
		foreach($options as $option){
			if(('' == $val || !$val || !isset($val)) && isset($option['selected']) && $option['selected']){ 
				$val = $option['value'];
			}
			if($val == $option['value']){ 
				$class = ' selected';
			} else {
				$class = '';
			}
			$output .= '<a href="#" class="' . esc_attr( 'preview-icon' . $class ) . '" title="' . esc_attr( $option['title'] ) . '"><img src="' . esc_url( THEME_URI.'/'.$option['img'] ) . '" alt="' . esc_attr( $option['value'] ) . '"  /></a>';
		}
		$output .= '<input type="hidden" name="setting-homepage_widgets" class="val" value="' . esc_attr( $val ) . '" />';
		return $output;
	}
}

if(!function_exists('themify_footer_widgets')){
	/**
	 * Widgets module function
	 * @return string Module markup
	 */
	function themify_footer_widgets(){
		$data = themify_get_data();
		$val = isset($data['setting-footer_widgets'])? $data['setting-footer_widgets'] : null;
		$options = array(
			array(
				'value' => 'footerwidget-4col',
				'img' => 'themify/img/sidebars/4col.png',
				'title' => __('Widgets 4 Columns', 'themify')),
			array(
				'value' => 'footerwidget-3col',
				'img' => 'themify/img/sidebars/3col.png',
				'title' => __('Widgets 3 Columns', 'themify'),
				'selected' => true),
			array(
				'value' => 'footerwidget-2col',
				'img' => 'themify/img/sidebars/2col.png',
				'title' => __('Widgets 2 Columns', 'themify')),
			array(
				'value' => 'footerwidget-1col',
				'img' => 'themify/img/sidebars/1col.png',
				'title' => __('Widgets 1 Column', 'themify')),
			array(
				'value' => 'none',
				'img' => 'themify/img/sidebars/none.png',
				'title' => __('No Widgets', 'themify'))
		);
		$output = '';
		foreach($options as $option){
			if(('' == $val || !$val || !isset($val)) && isset($option['selected']) && $option['selected']){ 
				$val = $option['value'];
			}
			if($val == $option['value']){ 
				$class = 'selected';
			} else {
				$class = '';
			}
			$output .= '<a href="#" class="' . esc_attr( 'preview-icon ' . $class ) . '" title="' . esc_attr( $option['title'] ) . '"><img src="' . esc_url( THEME_URI.'/'.$option['img'] ) . '" alt="' . esc_attr( $option['value'] ) . '"  /></a>';
		}
		$output .= '<input type="hidden" name="setting-footer_widgets" class="val" value="' . esc_attr( $val ) . '" />';
		return $output;
	}
}

if(!function_exists('themify_manage_twitter_settings')){
	/**
	 * Twitter API Settings
	 * @return string
	 */
	function themify_manage_twitter_settings() {
		$prefix = 'setting-twitter_settings_';
		$consumer_key = themify_get( $prefix.'consumer_key' );
		$consumer_secret = themify_get( $prefix.'consumer_secret' );

		$out = '<div class="themify-info-link">'.sprintf(
			__('<a href="%s">Twitter access</a> is required for Themify Twitter widget and Twitter shortcode, read this <a href="%s">documentation</a> for more details.', 'themify'),
			'https://dev.twitter.com/apps/new',
			'http://themify.me/docs/setting-up-twitter'
		)
		.'</div>';
		$out .= '<p><label class="label" for="' . esc_attr( $prefix . 'consumer_key' ) . '">'.__('Consumer Key', 'themify').'</label>';
		$out .= '<input type="text" id="' . esc_attr( $prefix . 'consumer_key' ) . '" name="' . esc_attr( $prefix . 'consumer_key' ) . '" class="width10" value="' . esc_attr( $consumer_key ) . '" /></p>';

		$out .= '<p><label class="label" for="' . esc_attr( $prefix . 'consumer_secret' ) . '">'.__('Consumer Secret', 'themify').'</label>';
		$out .= '<input type="text" id="' . esc_attr( $prefix . 'consumer_secret' ) . '" name="' . esc_attr( $prefix . 'consumer_secret' ) . '" class="width10" value="' . esc_attr( $consumer_secret ) . '" /></p>';

		return $out;
	}
}

if(!function_exists('themify_webfonts_subsets')) {
	/**
	 * Module to specify additional characters subsets
	 * @param array Themify data
	 * @return string Module markup
	 * @since 1.3.9
	 */
	function themify_webfonts_subsets($data = array()){
		

		// List of fonts, recommended or full
		$key = 'setting-webfonts_list';
		$html = '<p>
					<span class="label">' . __('Google Fonts List', 'themify') . '</span>';

			// Recommended list
			$html .= '<label for="' . esc_attr( $key . '_recommended' ) . '">
					<input ' . checked( themify_check( $key )? themify_get( $key ) : 'recommended', 'recommended', false) . ' type="radio" id="' . esc_attr( $key . '_recommended' ) . '" name="' . esc_attr( $key ) . '" value="recommended" /> ' .  __( 'Show recommended Google Fonts only', 'themify' ) . '</label><br/>';

			// Full list
			$html .= '<span class="pushlabel">
					<label for="' . esc_attr( $key . '_full' ) . '">
					<input ' . checked( themify_check( $key )? themify_get( $key ) : '', 'full', false ) . ' type="radio" id="' . esc_attr( $key . '_full' ) . '" name="' . esc_attr( $key ) . '" value="full" /> ' . __( 'Show all Google Fonts (showing all fonts will take longer to load)', 'themify' ) . '</label>
					</span>
				</p>';
                $subsets = array(
                                'arabic',
                                'cyrillic',
                                'cyrillic-ext',
                                'devanagari',
                                'greek',
                                'greek-ext',
                                'hebrew',
                                'khmer',
                                'latin',
                                'latin-ext',
                                'vietnamese'
                                );
		// Filter by character subset
		$key = 'setting-webfonts_subsets';
                $val = themify_get( $key );
                $selected_subset = array();   
                if($val){
                    $selected_subset = explode(',',$val);
                    $selected_subset = array_map('trim',$selected_subset);
                }
		$html .= '<p><span class="label">' . __( 'Character Subsets', 'themify' ) . '</span>';
                $html.='<select size="11" multiple="multiple" class="width10 google_font_subset">';
                foreach($subsets as $s){
                    $selected = in_array($s,$selected_subset)?'selected="selected"':'';
                    $html.='<option '.$selected.' value="'.$s.'">'.$s.'</option>';
                }
                $html.='</select><input type="hidden" name="' . $key . '" value="'.$val.'" /> <br />
				</p>';

		$html .= '<p>
					<span class="pushlabel"><a href="#" class="refresh-webfonts button">'.__( 'Refresh List', 'themify' ).'</a><br/><small>' . __( 'If you made any changes to these settings, refresh the list.', 'themify' ) . '</small></span>
				</p>';

		return $html;
	}
}

if ( ! function_exists( 'themify_entries_navigation' ) ) {
	/**
	 * Display module to select numbered pagination or links to previous and next posts.
	 * @param array $data
	 * @return string $html Module markup.
	 * @since 1.6.0
	 */
	function themify_entries_navigation( $data = array() ) {
		$data = themify_get_data();
		$key = 'setting-entries_nav';
		$html = '<p>';
			// Numbered pagination
			$html .= '<label for="' . esc_attr( $key . '_numbered' ) . '">';
			$html .= '<input ' . checked( isset( $data[$key] )? $data[$key] : 'numbered', 'numbered', false) . ' type="radio" id="' . esc_attr( $key . '_numbered' ) . '" name="' . esc_attr( $key ) . '" value="numbered" /> ';
			$html .= __( 'Numbered Page Navigation (page 1, 2, 3, etc.)', 'themify' ) . '</label>';
			$html .= '<br/>';
			
			// Previous / Next links
			$html .= '<label for="' . esc_attr( $key . '_prevnext' ) . '">';
			$html .= '<input ' . checked( isset( $data[$key] )? $data[$key] : '', 'prevnext', false ) . ' type="radio" id="' . esc_attr( $key . '_prevnext' ) . '" name="' . esc_attr( $key ) . '" value="prevnext" /> ';
			$html .= __( 'Previous Posts and Next Posts Links', 'themify' ) . '</label>';
		$html .= '</p>';
		return $html;
	}
}

//////////////////////////////////////////////
// Add common modules
//////////////////////////////////////////////
if(!function_exists('themify_framework_theme_config_webfonts_subsets')){
	function themify_framework_theme_config_webfonts_subsets($themify_theme_config) {
		$themify_theme_config['panel']['settings']['tab']['general']['custom-module'][] =
			array(
				'title' => __('Google Fonts', 'themify'),
				'function' => 'themify_webfonts_subsets'
			)
		;
		return $themify_theme_config;
	};
	add_filter('themify_theme_config_setup', 'themify_framework_theme_config_webfonts_subsets');
}

if( ! function_exists( 'themify_framework_theme_config_add_twitter_settings' ) ) {
	/**
	 * Twitter Settings Tab
	 * @param array $themify_theme_config
	 * @return array
	 */
	function themify_framework_theme_config_add_twitter_settings($themify_theme_config) {
		$themify_theme_config['panel']['settings']['tab']['twitter_settings'] = array(
			'title' => __('Twitter Settings', 'themify'),
			'id' => 'twitter_settings',
			'custom-module' => array(
				array(
					'title' => __('Twitter API Settings', 'themify'),
					'function' => 'themify_manage_twitter_settings'
				)
			)
		);
		return $themify_theme_config;
	};
	add_filter('themify_theme_config_setup', 'themify_framework_theme_config_add_twitter_settings');
}

/**
 * Renders the option to disable responsive design
 *
 * @since 2.1.5
 * @return string
 */
function themify_disable_responsive_design_option( $data = array() ) {
	$out = '<p><label for="setting-disable_responsive_design"><input type="checkbox" id="setting-disable_responsive_design" name="setting-disable_responsive_design" ' . checked( themify_get( 'setting-disable_responsive_design' ), 'on', false ) . '/> ' . __( 'Check here to disable the responsive design.', 'themify' ) . '</label></p>';
        $out.='<div data-show-if-element="[name=setting-disable_responsive_design]" data-show-if-value=' . '["false","disable"]' . '>';
        $out.='<p><label for="setting-enable_mobile_zoom"><input type="checkbox" id="setting-enable_mobile_zoom" name="setting-enable_mobile_zoom" ' . checked( themify_get( 'setting-enable_mobile_zoom' ), 'on', false ) . '/> ' . __( 'Enable pinch to zoom on mobile (keep it disabled for better rendering)', 'themify' ) . '</label></p>';
        $out .= sprintf( '<p class="clearfix"><span class="label width10">%s</span></p>', esc_html__( 'Customizer Responsive Breakpoints:', 'themify' ) );

	$opt_data = themify_get_data();
	$pre = 'setting-customizer_responsive_design_';
	$bp_tablet_landscape = ( isset( $opt_data[ $pre. 'tablet_landscape'] ) && ! empty( $opt_data[ $pre . 'tablet_landscape'] ) ) ? $opt_data[ $pre . 'tablet_landscape'] : 1024;
	$bp_tablet = ( isset( $opt_data[ $pre. 'tablet'] ) && ! empty( $opt_data[ $pre . 'tablet'] ) ) ? $opt_data[ $pre . 'tablet'] : 768;
	$bp_mobile = ( isset( $opt_data[ $pre. 'mobile'] ) && ! empty( $opt_data[ $pre . 'mobile'] ) ) ? $opt_data[ $pre . 'mobile'] : 480;
        
	$out .= sprintf( '<div class="clearfix"><div class="label">%s</div><div class="label input-range width10"><div class="range-slider width8"></div><input type="text" name="%s" value="%s" data-min="%d" data-max="%d" class="width4" readonly> px</div></div>',
		esc_html__( 'Tablet Landscape', 'themify' ),
		$pre . 'tablet_landscape',
		$bp_tablet_landscape,
		769,
		1024,
		$bp_tablet_landscape
	);
	$out .= sprintf( '<div class="clearfix"><div class="label">%s</div><div class="label input-range width10"><div class="range-slider width8"></div><input type="text" name="%s" value="%s" data-min="%d" data-max="%d" class="width4" readonly> px</div></div>',
		esc_html__( 'Tablet', 'themify' ),
		$pre . 'tablet',
		$bp_tablet,
		681,
		768,
		$bp_tablet
	);
	$out .= sprintf( '<div class="clearfix"><div class="label">%s</div><div class="label input-range width10"><div class="range-slider width8"></div><input type="text" name="%s" value="%s" data-min="%d" data-max="%d" class="width4" readonly> px</div></div>',
		esc_html__( 'Mobile', 'themify' ),
		$pre . 'mobile',
		$bp_mobile,
		320,
		680,
		$bp_mobile
	);
        $out.='</div>';
	return $out;
}

/**
 * Show custom 404 page (filter)
 */
add_filter( 'posts_results', 'themify_404_display_static_page', 999 );

/**
 * Show custom 404 page (function)
 */
function themify_404_display_static_page( $posts ) {
	remove_filter( 'posts_results', 'themify_404_display_static_page', 999 ); 
	
	if ( ! is_admin() ) {
		$pageid = themify_get( 'setting-page_404' );

		if ( 0 != $pageid ) {
			if ( empty( $posts ) && is_main_query() && ! is_robots() && ! is_home() && ! is_feed() && ! is_search() && ( ! defined( 'DOING_AJAX' ) || ! DOING_AJAX ) ) {

				$posts = array( get_post( $pageid ) );
				add_action( 'wp', 'themify_404_header' );
				add_filter( 'body_class', 'themify_404_body_class' );
				add_filter( 'template_include', 'themify_404_template', 99 );

			}
			else {
				$count = count( $posts );

				if ( 1 == $count ) {
					// Show 404 if is draft AND user is not logged
					if ( 'draft' == $posts[0]->post_status && ! is_user_logged_in() && is_main_query() && ! is_robots() && ! is_home() && ! is_feed() && ! is_search() && ( ! defined( 'DOING_AJAX' ) || ! DOING_AJAX ) ) {

						$posts = array( get_post( $pageid ) );
						add_action( 'wp', 'themify_404_header' );
						add_filter( 'body_class', 'themify_404_body_class' );
						add_filter( 'template_include', 'themify_404_template', 99 );

					}
					// Do a 404 if the 404 page is opened directly
					elseif ( 'page' == $posts[0]->post_type && $posts[0]->ID == $pageid ) {

						add_action( 'wp', 'themify_404_header' );
						add_filter( 'body_class', 'themify_404_body_class' );

					}
				}
			}
		}
	}

	return $posts;
}

/**
 * Send a 404 HTTP header
 */
function themify_404_header() {
	remove_action( 'wp', 'themify_404_header' );
	status_header( 404 );
	nocache_headers();

}

/**
 * Adds the error404 class to the body classes
 */
function themify_404_body_class( $classes ) {
	remove_action( 'body_class', 'themify_404_body_class' );
	$classes[] = 'error404';
	return $classes;
}

/**
 * Set 404 page template
 */
function themify_404_template( $template ) {
	remove_action( 'template_include', 'themify_404_template', 99 );

	global $wp_query;
	global $themify;

	$pageid = themify_get( 'setting-page_404' );

	if ( $pageid > 0 ) {
		$wp_query = null;
		$wp_query = new WP_Query();
		$wp_query->query( 'page_id=' . $pageid );
		$wp_query->the_post();

		// START custom variables ($template, global $themify)

			// PAGE TEMPLATE ($template)

			$template = get_page_template();

			// PAGE LAYOUT (global $themify)

			$layout = ( themify_get( 'page_layout' ) != 'default' && themify_check( 'page_layout' ) ) ? themify_get( 'page_layout' ) : themify_get( 'setting-default_page_layout' );
			
			if ( $layout != '' ) {
				$themify->layout = $layout;
			}

			// PAGE TITLE VISIBILITY (global $themify)

			$hide_page_title = get_post_meta( $pageid, 'hide_page_title', true );

			if ( ! empty( $hide_page_title ) && 'default' != $hide_page_title ) {
				$themify->page_title = $hide_page_title;
			} else {
				$themify->page_title = themify_check( 'setting-hide_page_title' ) ? themify_get( 'setting-hide_page_title' ) : 'no';
			}
			
			if ( 'yes' == $themify->page_title ) {
				add_filter( 'woocommerce_show_page_title', '__return_false' );
			}

		// END custom variables ($template, global $themify)

		rewind_posts();
	}

	return $template;
}

if ( ! function_exists( 'themify_generic_slider_controls' ) ) {
	/**
	 * Creates a general module to setup slider parameters
	 * @param $prefix
	 * @return string
	 */
	function themify_generic_slider_controls( $prefix ) {
		/**
		 * Associative array containing theme settings
		 * @var array
		 */
		$data = themify_get_data();

		$auto_options = apply_filters( 'themify_generic_slider_auto',
			array(
				__('4 Secs (default)', 'themify') => 4000,
				__('Off', 'themify') => 'off',
				__('1 Sec', 'themify') => 1000,
				__('2 Secs', 'themify') => 2000,
				__('3 Secs', 'themify') => 3000,
				__('4 Secs', 'themify') => 4000,
				__('5 Secs', 'themify') => 5000,
				__('6 Secs', 'themify') => 6000,
				__('7 Secs', 'themify') => 7000,
				__('8 Secs', 'themify') => 8000,
				__('9 Secs', 'themify') => 9000,
				__('10 Secs', 'themify')=> 10000
			)
		);
		$speed_options = apply_filters( 'themify_generic_slider_speed',
			array(
				__('Fast', 'themify') => 500,
				__('Normal', 'themify') => 1000,
				__('Slow', 'themify') => 1500
			)
		);
		$effect_options = array(
			array('name' => __('Slide', 'themify'), 'value' => 'slide'),
			array('name' => __('Fade', 'themify'), 'value' =>'fade')
		);

		/**
		 * Auto Play
		 */
		$output = '<p>
						<span class="label">' . __('Auto Play', 'themify') . '</span>
						<select name="' . esc_attr( $prefix ) . 'autoplay">';
						foreach ( $auto_options as $name => $val ) {
							$output .= '<option value="' . esc_attr( $val ) . '" ' . selected( themify_get( $prefix . 'autoplay' ), themify_check( $prefix . 'autoplay' ) ? $val : 4000, false ) . '>' . esc_html( $name ) . '</option>';
						}
		$output .= '	</select>
					</p>';

		/**
		 * Effect
		 */
		$output .= '<p>
						<span class="label">' . __( 'Effect', 'themify' ) . '</span>
						<select name="' . esc_attr( $prefix ) . 'effect">' .
						themify_options_module( $effect_options, $prefix . 'effect' ) . '
						</select>
					</p>';

		/**
		 * Transition Speed
		 */
		$output .= '<p>
						<span class="label">' . __( 'Transition Speed', 'themify' ) . '</span>
						<select name="' . esc_attr( $prefix ) . 'transition_speed">';
						foreach ( $speed_options as $name => $val ) {
							$output .= '<option value="' . esc_attr( $val ) . '" ' . selected( themify_get( $prefix . 'transition_speed' ), themify_check( $prefix . 'transition_speed' ) ? $val : 500, false ) . '>' . esc_html( $name ) . '</option>';
						}
		$output .= '	</select>
					</p>';

		return apply_filters( 'themify_generic_slider_controls', $output );
	}
}

/**
 * Display select element with featured image sizes + blank slot
 * @param String $key setting name
 * @return String
 * @since 1.1.5
 */
function themify_feature_image_sizes_select($key = ''){
	/** Define WP Featured Image sizes + blank + Themify's image script
	 * @var array */
	$themify_layout_feature_sizes = themify_get_image_sizes_list();

	$output = '<p class="show_if_disabled_img_php">
				<span class="label">' . __('Featured Image Size', 'themify') . '</span>
				<select name="' . esc_attr( 'setting-' . $key ) . '">';
	foreach($themify_layout_feature_sizes as $option){
		if($option['value'] == themify_get('setting-'.$key.'')){
			$output .= '<option value="' . esc_attr( $option['value'] ) . '" selected="selected">';
				$output .= esc_html( $option['name'] );
			$output .= '</option>';
		} else {
			$output .= '<option value="' . esc_attr( $option['value'] ) . '">' . esc_html( $option['name'] ) . '</option>';
		}
	}
	$output .= '</select></p>';

	return $output;
}




// Add Google Map Api page
function themify_add_settings_page($themify_theme_config){
    	
        $themify_theme_config['panel']['settings']['tab']['google_map'] = array(
                'title' => __('Google Map', 'themify'),
                'id' => 'google_map',
                'custom-module' => array(
                        array(
							'title' => __('Google Map API Settings','themify'),
							'function' =>'themify_google_map_key'
                        )
                )
        );
    return $themify_theme_config;
}
add_filter('themify_theme_config_setup','themify_add_settings_page',11,1);

/**
 * Display google map api key input
 * @return String
 * @since 2.7.7
 */
function themify_google_map_key($data=array()){
    $google_map_key = themify_get( 'setting-google_map_key' );
    return '<p><span class="label">' . __( 'Google Map Key', 'themify' ) . '</span> <input type="text" class="width10" name="setting-google_map_key" value="' . esc_attr( $google_map_key ) . '" /> <br />
				<span class="pushlabel"><small>'.__('Google API key is required to use Builder Map module and Map shortcode.','themify').' <a href="//developers.google.com/maps/documentation/javascript/get-api-key#key" target="_blank">' . __( 'Generate an API key', 'themify' ) . '</a> and insert it here.</small></span></p>';
}