<?php
/**
 * The template for displaying product content within loops
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/content-product.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woothemes.com/document/template-structure/
 * @author  WooThemes
 * @package WooCommerce/Templates
 * @version 2.6.1
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly
}

global $product, $anps_shop_data;

// Ensure visibility
if ( ! $product || ! $product->is_visible() ) {
	return;
}

// Extra post classes
$classes = array();

switch( $anps_shop_data['shop_columns'] ) {
    case '2 columns': $classes[] = 'col-sm-6'; break;
    case '3 columns': $classes[] = 'col-sm-4'; break;
    case '4 columns': $classes[] = 'col-sm-3'; break;
}
?>
<li <?php post_class( $classes ); ?>>
<div class="productwrap">
	<?php do_action( 'woocommerce_before_shop_loop_item' ); ?>

		<div class="product-header">
			<?php
				/**
				 * woocommerce_before_shop_loop_item_title hook
				 *
				 * @hooked woocommerce_show_product_loop_sale_flash - 10
				 * @hooked woocommerce_template_loop_product_thumbnail - 10
				 */
				do_action( 'woocommerce_before_shop_loop_item_title' );
				echo '<div class="add-to-cart-wrapper">';
				echo '<a class="permalink" href="'. get_the_permalink().'" alt="'.get_the_title().'"></a>'; 
				
				echo '</div>';

			?>
		</div>

		<a href="<?php the_permalink(); ?>"><h2 class="product-title"><?php the_title(); ?></h2></a>
		<div class="product-desc">
		<?php echo apply_filters( 'woocommerce_short_description', $post->post_excerpt ) ?>
				<?php
			/**
			 * woocommerce_after_shop_loop_item_title hook
			 *
			 * @hooked woocommerce_template_loop_rating - 5
			 * @hooked woocommerce_template_loop_price - 10
			 */		
			remove_action( 'woocommerce_after_shop_loop_item_title','woocommerce_template_loop_price');
			do_action('woocommerce_after_shop_loop_item_title');
		?>
		</div>
		<div class="clearfix"></div>
		<div class="product-footer">
		<?php
                add_action( 'woocommerce_after_shop_loop_item','woocommerce_template_loop_price', 5);
		do_action( 'woocommerce_after_shop_loop_item' ); ?>
		</div>
	
</div>
</li>