<?php 
/**
 * The template for displaying product content within loops.
 *
 * Override this template by copying it to yourtheme/woocommerce/content-product.php
 *
 * @author 		WooThemes
 * @package 	WooCommerce/Templates
 * @version     2.5.0
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly
}

global $product, $woocommerce_loop;

// Store loop count we're currently on
if ( empty( $woocommerce_loop['loop'] ) ) {
	$woocommerce_loop['loop'] = 0;
}

// Store column count for displaying the grid
if ( empty( $woocommerce_loop['columns'] ) ) {
	$woocommerce_loop['columns'] = apply_filters( 'loop_shop_columns', 4 );
}
// Ensure visibility
if ( ! $product || ! $product->is_visible() ) {
	return;
}
// Increase loop count
$woocommerce_loop['loop']++;

// Extra post classes
$classes = array();
if ( 0 == ( $woocommerce_loop['loop'] - 1 ) % $woocommerce_loop['columns'] || 1 == $woocommerce_loop['columns'] ) {
    $classes[] = 'first';
}
if ( 0 == $woocommerce_loop['loop'] % $woocommerce_loop['columns'] ) {
    $classes[] = 'last';
}

global $anps_shop_data;
$clearfix_class = false;
if( isset($anps_shop_data['shop_columns']) && ( is_shop() || is_product_category() || is_product_tag() ) ) {
	switch( $anps_shop_data['shop_columns'] ) {
		case '2 columns': 
                    $classes[] = 'col-sm-6'; 
                    if($woocommerce_loop['loop']%2==0) {
                        $clearfix_class = true;
                    }
                    break;
		case '3 columns': 
                    $classes[] = 'col-sm-4'; 
                    if($woocommerce_loop['loop']%3==0) {
                        $clearfix_class = true;
                    }
                    break;
		case '4 columns': 
                    $classes[] = 'col-sm-3'; 
                    if($woocommerce_loop['loop']%4==0) {
                        $clearfix_class = true;
                    }
                    break;
	}
} elseif(isset($anps_shop_data['shop_columns'])) {
	switch( $anps_shop_data['shop_columns'] ) {
		case '2 columns': 
                    $classes[] = 'col-sm-6'; 
                    if($woocommerce_loop['loop']%2==0) {
                        $clearfix_class = true;
                    }
                    break;
		case '3 columns': 
                    $classes[] = 'col-sm-4'; 
                    if($woocommerce_loop['loop']%3==0) {
                        $clearfix_class = true;
                    }
                    break;
		case '4 columns': 
                    $classes[] = 'col-sm-3'; 
                    if($woocommerce_loop['loop']%4==0) {
                        $clearfix_class = true;
                    }
                    break;
	}
} else {
    $classes[] = 'col-sm-4'; 
}

?>
<li <?php post_class( $classes ); ?>>
<div class="productwrap">
	<?php do_action( 'woocommerce_before_shop_loop_item' ); ?>

		<div class="product-header">
			<?php
				/**
				 * woocommerce_before_shop_loop_item_title hook
				 *
				 * @hooked woocommerce_show_product_loop_sale_flash - 10
				 * @hooked woocommerce_template_loop_product_thumbnail - 10
				 */
				do_action( 'woocommerce_before_shop_loop_item_title' );
				echo '<div class="add-to-cart-wrapper">';
				echo '<a class="permalink" href="'. get_the_permalink().'" alt="'.get_the_title().'"></a>'; 
				
				echo '</div>';

			?>
		</div>

		<a href="<?php the_permalink(); ?>"><h2 class="product-title"><?php the_title(); ?></h2></a>
		<div class="product-desc">
		<?php echo apply_filters( 'woocommerce_short_description', $post->post_excerpt ) ?>
				<?php
			/**
			 * woocommerce_after_shop_loop_item_title hook
			 *
			 * @hooked woocommerce_template_loop_rating - 5
			 * @hooked woocommerce_template_loop_price - 10
			 */		
			remove_action( 'woocommerce_after_shop_loop_item_title','woocommerce_template_loop_price');
			do_action('woocommerce_after_shop_loop_item_title');
		?>
		</div>
		<div class="clearfix"></div>
		<div class="product-footer">
		<?php
                add_action( 'woocommerce_after_shop_loop_item','woocommerce_template_loop_price', 5);
		do_action( 'woocommerce_after_shop_loop_item' ); ?>
		</div>
	
</div>
</li>
<?php if($clearfix_class) : ?>
<div class="clearfix"></div>
<?php endif; ?>