<?php
/* CONSTANTS */
define('ANPS_TEMPLATE_LANG', 'kataleya');
load_theme_textdomain( 'kataleya', get_template_directory() . '/languages' );


include_once( ABSPATH . 'wp-admin/includes/plugin.php' );

// Add layer slider skins 
if ( is_plugin_active( 'layersliderwp/layerslider.php' )) {
    LS_Sources::addSkins( get_template_directory().'/ls-skins' );
}

/* include theme options */
if(!is_admin()) {
    include_once get_template_directory().'/anps-framework/classes/Options.php'; 
    include_once get_template_directory().'/anps-framework/classes/Contact.php'; 
    $anps_page_data = $options->get_page_setup_data();
    $anps_options_data = $options->get_page_data(); 
    $anps_media_data = $options->get_media(); 
    $anps_social_data = $options->get_social(); 
    $anps_contact_data = $contact->get_data();
    $anps_shop_data = $options->get_shop_setup_data();
}
if(is_admin()) {
    /* Checking google fonts subsets for each font in admin */
    include_once 'anps-framework/classes/gfonts_ajax.php';
}
/* Include helpers */
include_once 'anps-framework/helpers.php';
/* Install plugins */
include_once 'anps-framework/install_plugins.php';
/* Include shortcodes */
include_once 'anps-framework/shortcodes.php';
/* Admin bar theme options menu */
include_once 'anps-framework/classes/adminBar.php';
/* Widgets */
include_once 'anps-framework/widgets/widgets.php';
/* Portfolio */ 
include_once 'anps-framework/portfolio.php';
add_action('init', 'anps_portfolio');
function anps_portfolio() {
    new Portfolio();
}
/* END Portfolio */
/* Gallery images */
include_once 'anps-framework/gallery_images.php';
/* Menu metaboxes */
include_once 'anps-framework/menu_meta.php';
/* Blog type meta */
include_once 'anps-framework/page_meta.php';
/* Portfolio meta */
include_once 'anps-framework/portfolio_meta.php';
/* Content Width */
if ( ! isset( $content_width ) ) {
    $content_width = 1140;
}
/* Automatic Feed Links */
add_theme_support( 'automatic-feed-links' );
/* Image sizes */
// Blog
add_image_size('blog-one-sidebar', 848, 268, true);
add_image_size('blog-grid', 720, 422, true);
add_image_size('blog-full', 1140, 360, true);
add_image_size('blog-masonry-3-columns', 720, 0, false);
add_image_size('blog-masonry-4-columns', 526, 0, false);
// Recent portfolio
add_image_size('portfolio-thumb', 780, 458, true);
/* Megamenu */
class description_walker extends Walker_Nav_Menu {
    function start_el(&$output, $item, $depth = 0, $args = array(), $current_object_id = 0) { 
        /*$menu_separate = get_post_meta($item->object_id, $key ='anps_menu_separate', $single = true); 
        if($menu_separate=="1") { 
            $item->url = $item->url;
        } else { 
            if(is_front_page()) {
                $item->url = $item->url;
            } else {
                $item->url = get_site_url()."/".$item->url;
            }
        }*/
        if(strpos($item->url,"://")===false){
            if(is_front_page()) {
                $item->url = $item->url;
            } else {
                $item->url = get_site_url()."/".$item->url;
            }
        }
        
        global $wp_query;
        $indent = ( $depth ) ? str_repeat( "\t", $depth ) : '';
        $class_names = $value = '';
        $classes = empty( $item->classes ) ? array() : (array) $item->classes;
        $class_names = join( ' ', apply_filters( 'nav_menu_css_class', array_filter( $classes ), $item ) );
        $class_names = ' class="'. esc_attr( $class_names ) . '"';

        $output .= $indent . '<li' . $value . $class_names .'>';
        $attributes  = ! empty( $item->attr_title ) ? ' title="'  . esc_attr( $item->attr_title ) .'"' : '';
        $attributes .= ! empty( $item->target )     ? ' target="' . esc_attr( $item->target     ) .'"' : '';
        $attributes .= ! empty( $item->xfn )        ? ' rel="'    . esc_attr( $item->xfn        ) .'"' : '';
        $attributes .= ! empty( $item->url )        ? ' href="'   . esc_attr( $item->url       ) .'"' : '';
        $description  = ! empty( $item->description ) ? '<span>'.esc_attr( $item->description ).'</span>' : '';
        $description = do_shortcode($description);

        $append = "";
        $prepend = "";
        
        if($depth==0) {
            $description = $append = $prepend = "";
        }
        $locations = get_theme_mod('nav_menu_locations');
        
        if($locations['primary']) {
            $item_output = "";
            $item_output = $args->before;
            $item_output .= '<a'. $attributes .'>';
            $item_output .= $args->link_before .$prepend.apply_filters( 'the_title', $item->title, $item->ID ).$append;
            $item_output .= '</a>';
            $item_output .= $description.$args->link_after;
            $item_output .= $args->after;
            $output .= apply_filters( 'walker_nav_menu_start_el', $item_output, $item, $depth = 0, $args, $args, $current_object_id = 0 );
        }
    }
}
/* Producsts per page */
global $anps_shop_data;
if( isset($anps_shop_data['shop_per_page']) ) {
    add_filter( 'loop_shop_per_page', create_function( '$cols', 'return ' . $anps_shop_data['shop_per_page'] . ';' ), 20 );
}
/* On setup theme */
add_action('after_setup_theme', 'anps_register_custom_fonts');
function anps_register_custom_fonts() { 
    if (!isset($_GET['stylesheet'])) {
        $_GET['stylesheet'] = '';
    }
    $theme = wp_get_theme($_GET['stylesheet']);
    if (!isset($_GET['activated'])) {
        $_GET['activated'] = '';
    }
    if ($_GET['activated'] == 'true' && $theme->get_template() == ANPS_TEMPLATE_LANG) { 
        include_once get_template_directory().'/anps-framework/classes/Options.php';
        include_once get_template_directory().'/anps-framework/classes/Style.php';
        /* Add google fonts*/
        if(get_option('anps_google_fonts', '')=='') {
            $style->update_gfonts_install();
        }
        /* Add custom fonts to options */
        $style->get_custom_fonts();
        /* Add default fonts */
        if(get_option('font_type_1', '')=='') {
            update_option("font_type_1", "pacifico-webfont");
        }
        if(get_option('font_type_2', '')=='') {
            update_option("font_type_2", "Arial");
        }
        update_option("rss_use_excerpt", "1");
    }
    $fonts_installed = get_option('fonts_intalled');
    
    if($fonts_installed==1)
        return;
    
    /* Get custom font */
    include_once get_template_directory().'/anps-framework/classes/Style.php';
    $fonts = $style->get_custom_fonts();
    /* Update custom font */
    foreach($fonts as $name=>$value) { 
        $arr_save[] = array('value'=>$value, 'name'=>$name);
    }
    update_option('anps_custom_fonts', $arr_save);
    update_option('fonts_intalled', 1);
}
/* Admin only scripts */
function anps_load_custom_wp_admin_scripts($hook) {
    //wp_enqueue_style( "admin-font-awesome", "//maxcdn.bootstrapcdn.com/font-awesome/4.2.0/css/font-awesome.min.css" ); 
    wp_enqueue_style( "font-awesome-4-4", '//netdna.bootstrapcdn.com/font-awesome/4.4.0/css/font-awesome.min.css' ); 
    wp_enqueue_style( "wp-backend", get_template_directory_uri() . "/anps-framework/css/wp-backend.css" );
    wp_enqueue_style( "admin-style", get_template_directory_uri() . '/anps-framework/css/admin-style.css' ); 
    wp_enqueue_style( "vc-custom", get_template_directory_uri() . '/css/vc_custom.css' ); 

    global $my_admin_page;
    $screen = get_current_screen();
    if( is_admin() && ($screen->id == 'widgets') ) {
        wp_enqueue_style("select2-css", get_template_directory_uri()  . "/anps-framework/css/select2.min.css");
        wp_enqueue_script('select2', get_template_directory_uri() . "/anps-framework/js/select2.min.js", array( 'jquery' ), false, true);
    }
    wp_enqueue_script('wp_backend_js', get_template_directory_uri() . "/anps-framework/js/wp_backend.js", array( 'jquery' ), false, true);


    if( 'appearance_page_theme_options' != $hook && 'reservation_page_anps_reservation_settings' != $hook && 'orders_page_anps_orders_settings' != $hook ) {
        return;
    }

    /* Theme Options Style */
    if(!isset($_GET['sub_page']) || $_GET['sub_page'] == "theme_style" || $_GET['sub_page'] == "options") {
        wp_enqueue_style( "colorpicker", get_template_directory_uri() . '/anps-framework/css/colorpicker.css' );
    }
    wp_enqueue_script( "jquery_google", "//ajax.googleapis.com/ajax/libs/jquery/1.8.3/jquery.min.js" );
    if (isset($_GET['sub_page']) && ($_GET['sub_page'] == "options" || $_GET['sub_page'] == "options_page")) {
        wp_enqueue_script( "pattern", get_template_directory_uri() . "/anps-framework/js/pattern.js" );
    }
    if(!isset($_GET['sub_page']) || $_GET['sub_page'] == "theme_style" || $_GET['sub_page'] == "options") { 
        wp_enqueue_script( "colorpicker_theme", get_template_directory_uri() . "/anps-framework/js/colorpicker.js" ); 
        wp_enqueue_script( "colorpicker_custom", get_template_directory_uri() . "/anps-framework/js/colorpicker_custom.js" ); 
    }
    wp_enqueue_script( "theme-options", get_template_directory_uri() . "/anps-framework/js/theme-options.js" ); 
}
add_action( 'admin_enqueue_scripts', 'anps_load_custom_wp_admin_scripts' );
/* theme styles */
function anps_theme_styles() {     
    global $anps_options_data;
    
    if ( get_option('font_source_1') && get_option('font_source_1')=='Google fonts') {
        $font1_subset = get_option("font_type_1_subsets", array("latin", "latin-ext"));
        $font1_implode_subset = implode(",", $font1_subset);
        wp_enqueue_style( "font_type_1",  'https://fonts.googleapis.com/css?family=' . get_option('font_type_1', 'Open+Sans') . ':400italic,400,600,700,300&subset='.$font1_implode_subset);
    } else {
        wp_enqueue_style( "font_type_1",  'https://fonts.googleapis.com/css?family=Open+Sans:400italic,400,600,700,300&subset=latin,latin-ext');      
    }
        
    if ( get_option('font_source_2') && get_option('font_source_2')=='Google fonts' && get_option('font_type_1', 'Open+Sans')!=get_option('font_type_2', 'Arial')) {
        $font2_subset = get_option("font_type_2_subsets", array("latin", "latin-ext")); 
        $font2_implode_subset = implode(",", $font2_subset);
        wp_enqueue_style( "font_type_2",  'https://fonts.googleapis.com/css?family=' . get_option('font_type_2', 'Arial') . ':400italic,400,600,700,300&subset='.$font2_implode_subset);
    }

    wp_enqueue_style( "theme_main_style", get_bloginfo( 'stylesheet_url' ) );
    $responsive = "";
    if (isset($anps_options_data['responsive'])) {
        $responsive = $anps_options_data['responsive'];
    }
}
/* scripts and styles */
function anps_scripts_and_styles() {
    wp_enqueue_script("jquery");
    wp_enqueue_style( "theme_wordpress_style", get_template_directory_uri() . "/css/wordpress.css" );
    wp_enqueue_style( "custom", get_template_directory_uri() . '/custom.css' );
    //wp_enqueue_style("font-awesome", "//netdna.bootstrapcdn.com/font-awesome/4.2.0/css/font-awesome.min.css");
    wp_enqueue_style("font-awesome-4-4", "//netdna.bootstrapcdn.com/font-awesome/4.4.0/css/font-awesome.min.css");
    wp_enqueue_style( "prettyphoto", get_template_directory_uri() . '/css/prettyPhoto.css' );
    wp_enqueue_style( "anpswoocommerce", get_template_directory_uri() . '/css/anpswoocommerce.css', array() );
    wp_enqueue_style("custom_styles", get_template_directory_uri()  . "/includes/custom-styles.php");
    

    global $is_IE;

    if ( $is_IE ) {
        wp_enqueue_style("ie-fix", get_template_directory_uri() . '/css/ie-fix.css');
        wp_enqueue_script( "iefix", get_template_directory_uri()  . "/js/ie-fix.js", '', '', true );
    }
  
    //wp_register_script( "fullwidth-slider", get_template_directory_uri()  . "/js/fullwidth-slider.js", '', '', true );
    if( ! isset( $_GET['vceditor'] ) ) {
        wp_deregister_script( 'isotope' );
        wp_enqueue_script( "anps-isotope", get_template_directory_uri()  . "/js/isotope.js", '', '', true );
    }
    wp_enqueue_script( "smoothscroll", get_template_directory_uri()  . "/js/smoothscroll.js", '', '', true );
    
    wp_enqueue_script( "alert", get_template_directory_uri()  . "/js/bootstrap/alert.js", '', '', true );
    wp_register_script( "tab", get_template_directory_uri()  . "/js/bootstrap/tab.js", '', '', true );
    wp_register_script( "collapse", get_template_directory_uri()  . "/js/bootstrap/collapse.js", '', '', true );
    wp_enqueue_script( "carousel", get_template_directory_uri()  . "/js/bootstrap/carousel.js", '', '', true );
    wp_enqueue_script( "transition", get_template_directory_uri()  . "/js/bootstrap/transition.js", '', '', true );

    global $anps_social_data;
    $google_maps_api = '';
    
    if( isset($anps_social_data['anps_google_maps']) && $anps_social_data['anps_google_maps'] != '' ) {
        $google_maps_api = '?key=' . $anps_social_data['anps_google_maps'];
    }
        
    wp_register_script( "gmap3_link", "https://maps.google.com/maps/api/js" . $google_maps_api, '', '', true );
    wp_register_script( "gmap3", get_template_directory_uri()  . "/js/gmap3.js", '', '', true );
    wp_enqueue_script( "touchSwipe", get_template_directory_uri()  . "/js/jquery.touchSwipe.js", array('jquery'), '', true );
    wp_enqueue_script( "anps-cookie", get_template_directory_uri()  . "/js/jquery.cookie.js", array('jquery'), '', true );
    wp_enqueue_script( "theme", get_template_directory_uri()  . "/js/theme.js", array('jquery'), '', true );
    wp_enqueue_script( "picturefill", get_template_directory_uri()  . "/js/picturefill.js", array('jquery'), '', true );
    wp_enqueue_script( "parallax", get_template_directory_uri()  . "/js/parallax.js", array('jquery'), '', true );
    wp_enqueue_script( "imagesloaded", get_template_directory_uri()  . "/js/imagesloaded.js", array('jquery'), '', true );
    wp_register_script( "jflickrfeed", get_template_directory_uri()  . "/js/jflickrfeed.js", array('jquery'), '', true );
    wp_enqueue_script( "prettyphoto", get_template_directory_uri()  . "/js/jquery.prettyPhoto.js", '', '', true );
}
add_action( 'wp_enqueue_scripts', 'anps_scripts_and_styles' );

/* Add Jetpack infinite scroll support */

function anps_infinite_scroll_init() {
    add_theme_support( 'infinite-scroll', array(
        'container'     => 'blog-posts',
        'footer'        => 'site-footer',
        'type'          => 'click',
        'wrapper'       => false,
    ) );
}

add_action( 'init', 'anps_infinite_scroll_init' );


/*************************/
/*WOOCOMMERCE*/
/*************************/
if ( in_array( 'woocommerce/woocommerce.php', apply_filters( 'active_plugins', get_option( 'active_plugins' ) ) ) ) {
    add_theme_support( 'woocommerce' );
    function woo_scripts_styles() {
        $woo_data = get_plugin_data(ABSPATH . 'wp-content/plugins/woocommerce/woocommerce.php'); 
        $woo_version = explode(".", $woo_data['Version']);
        /* If version 2.3 or higher load js for quantity +- */
        wp_enqueue_script("woo_quantity", get_template_directory_uri() . "/js/quantity_woo23.js",array("jquery"), "", true);
    }
    add_filter( 'woocommerce_enqueue_styles', 'woo_scripts_styles' );
    function anps_woocommerce_header() {
        global $woocommerce;

        global $anps_shop_data;

        if( isset($anps_shop_data['shop_hide_cart']) && $anps_shop_data['shop_hide_cart'] == "on" ) {
            return false;
        }

        ?>
        <div class="woo-header-cart">
            <a class="cart-contents" href="<?php echo $woocommerce->cart->get_cart_url(); ?>" title="<?php _e('View your shopping cart', 'woothemes'); ?>">
                <span><?php echo $woocommerce->cart->cart_contents_count;?></span>
                <i class="fa fa-shopping-cart"></i>
            </a>
        </div>
        <?php
    }

    // Ensure cart contents update when products are added to the cart via AJAX (place the following in functions.php)
    add_filter('add_to_cart_fragments', 'woocommerce_header_add_to_cart_fragment');

    function woocommerce_header_add_to_cart_fragment( $fragments ) {
        global $woocommerce;
        
        ob_start();
        
        ?>
        <a class="cart-contents" href="<?php echo $woocommerce->cart->get_cart_url(); ?>" title="<?php _e('View your shopping cart', 'woothemes'); ?>">
            <span><?php echo $woocommerce->cart->cart_contents_count;?></span>
            <i class="fa fa-shopping-cart"></i>
        </a>
        <div class="mini-cart">
            <?php woocommerce_mini_cart(); ?>
        </div>
        <?php

        $fragments['a.cart-contents'] = ob_get_clean();
        
        return $fragments;
    }

    /* Support for WooCommerce */
    add_theme_support("woocommerce");

    define("WOOCOMMERCE_USE_CSS", false );

if(!function_exists('myaccount_sidebar')) {
 function myaccount_sidebar($page) { ?>

            <div class="col-md-3 sidebar">

                <ul class="myaccount-menu">
                    <li class="widget-container widget_nav_menu">
                        <div class="menu-main-menu-container">
                            <ul class="menu">
                                <li class="menu-item<?php if($page == "myaccount"){ echo " current-menu-item page_item current_page_item current_page_parent"; } ?>"><a href="<?php echo get_permalink( get_option( 'woocommerce_myaccount_page_id' ) ); ?>"><?php _e("My Orders", ANPS_TEMPLATE_LANG); ?></a></li>
                                <?php if ( in_array( 'yith-woocommerce-wishlist/init.php', apply_filters( 'active_plugins', get_option( 'active_plugins' ) ) ) ): ?>
                                    <li class="menu-item<?php if($page == "wishlist"){ echo " current-menu-item page_item current_page_item current_page_parent"; } ?>"><a href="<?php echo get_permalink( get_option( 'yith_wcwl_wishlist_page_id' ) ); ?>"><?php _e("My Wishlist", ANPS_TEMPLATE_LANG); ?></a></li>
                                <?php endif; ?>
                                <li class="menu-item<?php if($page == "billing"){ echo " current-menu-item page_item current_page_item current_page_parent"; } ?>"><a href="<?php echo wc_get_endpoint_url( 'edit-address', 'billing' ); ?>"><?php _e("Edit Billing Address", ANPS_TEMPLATE_LANG); ?></a></li>
                                <li class="menu-item<?php if($page == "shipping"){ echo " current-menu-item page_item current_page_item current_page_parent"; } ?>"><a href="<?php echo wc_get_endpoint_url( 'edit-address', 'shipping' ); ?>"><?php _e("Edit Shipping Address", ANPS_TEMPLATE_LANG); ?></a></li>
                                <li class="menu-item<?php if($page == "change_account"){ echo " current-menu-item page_item current_page_item current_page_parent"; } ?>"><a href="<?php echo wc_customer_edit_account_url(); ?>"><?php _e("Change Account", ANPS_TEMPLATE_LANG); ?></a></li>
                                <?php
                                    if (is_user_logged_in()) {
                                        echo '<li><a href="'. wp_logout_url( get_permalink( woocommerce_get_page_id( 'myaccount' ) ) ) .'">' . __("Logout", ANPS_TEMPLATE_LANG) . '</a></li>';
                                    }
                                ?>
                            </ul>
                        </div>              
                    </li>
                </ul>

            </div>
        <?php
    }
}
    add_filter( 'woocommerce_output_related_products_args', 'jk_related_products_args' );
    function jk_related_products_args( $args ) {
        global $anps_shop_data;
        if(!isset($anps_shop_data['shop_related_per_page'])||$anps_shop_data['shop_related_per_page']=="") {
            $per_page = 3;
        } else {
            $per_page = $anps_shop_data['shop_related_per_page'];
        }
        $args['posts_per_page'] = $per_page;
        return $args;
    } 
}
/*************************/
/*END WOOCOMMERCE*/
/*************************/

/* Change comment form position (WordPress 4.4) */
function anps_comment_field_to_bottom( $fields ) {
    $comment_field = $fields['comment'];
    unset( $fields['comment'] );
    $fields['comment'] = $comment_field;
    return $fields;
}
add_filter( 'comment_form_fields', 'anps_comment_field_to_bottom' );