<?php if ( post_password_required() ) : ?>
<p><?php _e( 'This post is password protected. Enter the password to view any comments.', ANPS_TEMPLATE_LANG); ?></p>
<?php return; endif; ?>
<?php if ( have_comments() ) : ?>
    <h5 id="comments" class="comments-title"><?php echo __('comments', ANPS_TEMPLATE_LANG) . " <span class='color'>(".get_comments_number().")</span>"; ?></h5>
	<ul class="comment-list">
        <?php
    	   wp_list_comments(array( 'callback' => 'anps_comment' )); 
        ?>
	</ul>
<?php if ( get_comment_pages_count() > 1 && get_option( 'page_comments' ) ) : // Are there comments to navigate through? ?>
	<?php previous_comments_link( __( '&larr; Older Comments', ANPS_TEMPLATE_LANG) ); ?>
	<?php next_comments_link( __( 'Newer Comments &rarr;', ANPS_TEMPLATE_LANG) ); ?>
<?php endif; ?>
<?php else :
	if ( ! comments_open() ) :
?>
	<p><?php _e( 'Comments are closed.', ANPS_TEMPLATE_LANG); ?></p>
<?php endif; ?>
<?php endif; ?>
    
        
<?php
if(!isset($fields)) {
    $fields =  array(
        'author' => '<div class="col-sm-6"><input type="text" id="author" name="author" placeholder="'. __( 'Name', ANPS_TEMPLATE_LANG).'"></div>',
        'email'  => '<div class="col-sm-6"><input type="text" id="email" name="email" placeholder="'. __( 'E-mail', ANPS_TEMPLATE_LANG).'"></div>'
    ); 
}
if ( is_user_logged_in() ) {
    $defaults = array(
    'fields'               => apply_filters( 'comment_form_default_fields', $fields),
    'comment_field'        => '<div class="col-sm-12"><textarea id="message" placeholder="' . __("Message", ANPS_TEMPLATE_LANG) . '" name="comment" rows="5"></textarea></div></div>',
    'must_log_in'          => '<p class="must-log-in">You must be logged in to leave a reply.</p>',
    'logged_in_as'         => '<h5 class="comments-submit-title">' . __('leave a comment', ANPS_TEMPLATE_LANG) . '</h5><div class="row">',
    'comment_notes_before' => '<h2 class="comment-heading">' . __('Leave a reply', ANPS_TEMPLATE_LANG) . '</h2><div id="comment-form">',
    'title_reply' => '',
    'comment_notes_after'  => '<button data-form="submit" class="btn btn-md">Submit</button>',
    'id_form'              => 'commentform',
    'id_submit'            => 'submit'
 );
} else {
    $defaults = array(
    'fields'               => apply_filters( 'comment_form_default_fields', $fields),
    'comment_field'        => '</div><div class="row"><div class="col-sm-12"><textarea id="message" placeholder="' . __("Message", ANPS_TEMPLATE_LANG) . '" name="comment" rows="5"></textarea></div>',
    'must_log_in'          => '<p class="must-log-in">You must be logged in to leave a reply.</p>',
    'logged_in_as'         => '<div class="row contact-form"><h5 class="comments-submit-title">' . __('leave a comment', ANPS_TEMPLATE_LANG) . '</h5>',
    'comment_notes_before' => '<h5 class="comment-heading">' . __('leave a comment', ANPS_TEMPLATE_LANG) . '</h5><div class="row">',
    'title_reply' => '',
    'comment_notes_after'  => '</div>
                               <button data-form="submit" class="btn btn-md">Submit</button>',
    'id_form'              => 'commentform',
    'id_submit'            => 'submit'
 );
}
comment_form( $defaults ); 

if ( is_singular() ) wp_enqueue_script( "comment-reply" );