<?php

class AnpsTwitter extends WP_Widget {

    public function __construct() {
        parent::__construct(
            'AnpsTwitter', 'AnpsThemes - Twitter', array('description' => __('Twitter feed', ANPS_TEMPLATE_LANG),)
        );
    }

    function form($instance) {
        $instance = wp_parse_args((array) $instance, array('title' => '', 'account' => ''));

        $account = $instance['account'];
        $title = $instance['title'];
        ?>

        <p>
            <label for="<?php echo $this->get_field_id('title'); ?>"><?php _e("Title", ANPS_TEMPLATE_LANG); ?></label>
            <input id="<?php echo $this->get_field_id('title'); ?>" name="<?php echo $this->get_field_name('title'); ?>" type="text" class="widefat" value="<?php echo $instance['title']; ?>" />
        </p>
        <p>
            <label for="<?php echo $this->get_field_id('account'); ?>"><?php _e("Twitter account", ANPS_TEMPLATE_LANG); ?></label>
            <input id="<?php echo $this->get_field_id('account'); ?>" name="<?php echo $this->get_field_name('account'); ?>" type="text" class="widefat" value="<?php echo $instance['account']; ?>" />
        </p>
        <?php
    }

    function update($new_instance, $old_instance) {
        $instance = $old_instance;
        $instance['account'] = $new_instance['account'];
        $instance['title'] = $new_instance['title'];
        return $instance;
    }

    function widget($args, $instance) {
        extract($args, EXTR_SKIP);
        $title = $instance['title'];
        $account = $instance['account'];
        echo $before_widget;
        ?>

        <?php if($title) : ?>
            <h3 class="widget-title"><?php echo $title; ?></h3>
        <?php endif;
        echo $this->twitter_func($account);
        echo $after_widget;
    }
    
    function twitter_func($content) {    
        load_template(TEMPLATEPATH.'/includes/TwitterAPIExchange.php');
        $settings = array(
            'oauth_access_token' => "1485322933-oo8YU1ZTz5E4Zt92hTTbCdJoZxIJIabghjnsPkX",
            'oauth_access_token_secret' => "RfXHN2OXMkBYp3IaEqrBmPhUYR2N61P8pyHf8QXqM",
            'consumer_key' => "Zr397FLlTFM4RVBsoLVgA",
            'consumer_secret' => "3Z2wNAG2vvunam2mfJATxnJcThnqw1qu02Xy8QlqFI"
        );
        $url = 'https://api.twitter.com/1.1/statuses/user_timeline.json';
        $getfield = '?screen_name=' . $content . '&count=3';
        $requestMethod = 'GET';
        $twitter = new TwitterAPIExchange($settings);
        $tweets = json_decode($twitter->setGetfield($getfield)
                     ->buildOauth($url, $requestMethod)
                     ->performRequest());
        $return = '<div id="twitter" data-ride="carousel" class="carousel slide twitter">';
        $return .= "<div class='carousel-inner'>";
        $j=0;
        foreach( $tweets as $tweet ) {
            if($j=="0") {
                $class_active = ' active';
            } else {
                $class_active = '';
            }
            $tweet_text = $tweet->text;
            $tweet_text = preg_replace('/http:\/\/([a-z0-9_\.\-\+\&\!\#\~\/\,]+)/i', '<a href="http://$1" target="_blank">http://$1</a>', $tweet_text); //replace links
            $tweet_text = preg_replace('/@([a-z0-9_]+)/i', '<a href="http://twitter.com/$1" target="_blank">@$1</a>', $tweet_text); //replace users
            $return .= '<div class="item'.$class_active.'">' . $tweet_text . '</div>';    
            $j++;
        }
        $return .= "</div>";
        $return .= "<ol class='carousel-indicators'>";
        for($i=0;$i<count($tweets);$i++) {
            if($i==0) {
                $active_class = "active";
            } else {
                $active_class = "";
            }
            $return .= "<li data-target='#twitter' data-slide-to='".$i."' class='".$active_class."'></li>";
        }
        $return .= "</ol>";
        $return .= "</div>";
        return $return;
    }

}
add_action( 'widgets_init', create_function('', 'return register_widget("AnpsTwitter");') );
