<?php

class AnpsRecentPosts extends WP_Widget {

    public function __construct() {
        parent::__construct(
            'AnpsRecentPosts', 'AnpsThemes - Recent Posts', array('description' => __('Anps posts comments', ANPS_TEMPLATE_LANG), 'classname'=>"recent-posts-widget recent-widget")
        );
    }
    function form($instance) {
        $instance = wp_parse_args((array) $instance, array('title' => '', 'number' => ''));

        $number = $instance['number'];
        $title = $instance['title'];
        ?>

        <p>
            <label for="<?php echo $this->get_field_id('title'); ?>"><?php _e("Title", ANPS_TEMPLATE_LANG); ?></label>
            <input id="<?php echo $this->get_field_id('title'); ?>" name="<?php echo $this->get_field_name('title'); ?>" type="text" class="widefat" value="<?php echo $instance['title']; ?>" />
        </p>
        <p>
            <label for="<?php echo $this->get_field_id('number'); ?>"><?php _e("Number of posts to show:", ANPS_TEMPLATE_LANG); ?></label>
            <input id="<?php echo $this->get_field_id('number'); ?>" name="<?php echo $this->get_field_name('number'); ?>" type="text" size="3" value="<?php echo $instance['number']; ?>" />
        </p>
        <?php
    }

    function update($new_instance, $old_instance) {
        $instance = $old_instance;
        $instance['number'] = $new_instance['number'];
        $instance['title'] = $new_instance['title'];
        return $instance;
    }

    function widget($args, $instance) {
        extract($args, EXTR_SKIP);
        $title = $instance['title'];
        $number = $instance['number'];
        $args = 
        $posts = wp_get_recent_posts(array('numberposts'=>$number), OBJECT);
        echo $before_widget; 
        ?>

        <?php if($title) : ?>
            <h3 class="widget-title"><?php echo $title; ?></h3>
        <?php endif; ?>
            <ul>
                <?php foreach($posts as $item) : 
                    ?>
                <li>
                    <?php echo get_avatar($item->post_author, 116); ?>
                    <h5><?php echo $item->post_title; ?></h5>
                    <p><?php echo substr(str_replace(array("[vc_row]", "[vc_column]", "[vc_column_text]"), array("", "", ""),$item->post_content), 0, 55); ?></p>
                    <span class="post-date"><?php echo date("d.m.Y", strtotime($item->post_date)); ?></span>
                    <a href="<?php echo $item->guid; ?>"><?php _e("read more", ANPS_TEMPLATE_LANG);?><i class="fa fa-long-arrow-right"></i></a>
                </li>
                <?php endforeach; ?>
            </ul>
        <?php
        echo $after_widget;
    }

}

add_action( 'widgets_init', create_function('', 'return register_widget("AnpsRecentPosts");') );
