<?php

class AnpsFlickr extends WP_Widget {

    public function __construct() {
        parent::__construct(
            'AnpsFlickr', 'AnpsThemes - Flickr', array('description' => __('Show images from Flickr', ANPS_TEMPLATE_LANG),)
        );
    }

    function form($instance) {
        $instance = wp_parse_args((array) $instance, array('title' => '', 'account' => ''));

        $account = $instance['account'];
        $title = $instance['title'];
        ?>

        <p>
            <label for="<?php echo $this->get_field_id('title'); ?>"><?php _e("Title", ANPS_TEMPLATE_LANG); ?></label>
            <input id="<?php echo $this->get_field_id('title'); ?>" name="<?php echo $this->get_field_name('title'); ?>" type="text" class="widefat" value="<?php echo $instance['title']; ?>" />
        </p>
        <p>
            <label for="<?php echo $this->get_field_id('account'); ?>"><?php _e("Account", ANPS_TEMPLATE_LANG); ?></label>
            <input id="<?php echo $this->get_field_id('account'); ?>" name="<?php echo $this->get_field_name('account'); ?>" type="text" class="widefat" value="<?php echo $instance['account']; ?>" />
        </p>

        <?php
    }

    function update($new_instance, $old_instance) {
        $instance = $old_instance;
        $instance['account'] = $new_instance['account'];
        $instance['title'] = $new_instance['title'];
        return $instance;
    }

    function widget($args, $instance) {
        extract($args, EXTR_SKIP);
        $title = $instance['title'];
        $account = $instance['account'];
        wp_enqueue_script('jflickrfeed');
        echo $before_widget;
        ?>

        <?php if($title) : ?>
            <h3 class="widget-title"><?php echo $title; ?></h3>
        <?php endif; ?>

            <div class="flickr-widget" data-account="<?php echo $account; ?>"></div>

        <?php
        echo $after_widget;
    }

}

add_action( 'widgets_init', create_function('', 'return register_widget("AnpsFlickr");') );
