<?php
load_template(TEMPLATEPATH . '/anps-framework/shortcodes_functions.php');
load_template(TEMPLATEPATH . '/anps-framework/vc_shortcodes_icon_list.php');
/* SHORTCODES */
/* Accordion */
class WPBakeryShortCode_accordion extends WPBakeryShortCodesContainer {
    static function accordion_func( $atts,  $content ) {
       return anps_accordion_func($atts, $content);
    }
}
add_shortcode('accordion', array('WPBakeryShortCode_accordion','accordion_func'));
/* END Accordion */
/* Accordion item */
class WPBakeryShortCode_accordion_item extends WPBakeryShortCodesContainer {
    static function accordion_item_func( $atts,  $content ) { 
        return anps_accordion_item_func($atts, $content);
    }
}
add_shortcode('accordion_item', array('WPBakeryShortCode_accordion_item','accordion_item_func'));
/* END Accordion item */
/* Coming soon */
class WPBakeryShortCode_coming_soon extends WPBakeryShortCodesContainer {
    static function anps_coming_soon_func( $atts,  $content ) {
        return anps_coming_soon_func($atts, $content);
    }
}
add_shortcode('coming_soon', array('WPBakeryShortCode_coming_soon','anps_coming_soon_func'));
/* END Coming soon */
/* Contact */
class WPBakeryShortCode_contact extends WPBakeryShortCodesContainer {
    static function anps_contact_func($atts, $content) { 
        return anps_contact_func($atts, $content);
    }
}
add_shortcode("contact", array("WPBakeryShortCode_contact","anps_contact_func"));
/* END Contact */
/* Contact item */
class WPBakeryShortCode_Contact_Item extends WPBakeryShortCode {
    static function anps_contact_item_func($atts, $content) {
        return anps_contact_item_func($atts, $content);
    }
}
add_shortcode("form_item", array("WPBakeryShortCode_Contact_Item","anps_contact_item_func"));
/* END Contact item */
/* Contact button */
class WPBakeryShortCode_anps_contact_button extends WPBakeryShortCode {
    static function anps_contact_button_func($atts, $content) { 
        return anps_contact_button_func($atts, $content);
    }
}
add_shortcode("contact_button", array("WPBakeryShortCode_anps_contact_button","anps_contact_button_func"));
/* END Contact button */
/* Contact info */
class WPBakeryShortCode_contact_info extends WPBakeryShortCodesContainer {
    static function contact_info_func( $atts,  $content ) {
        return anps_contact_info_func($atts, $content);
    }
}
add_shortcode('contact_info', array('WPBakeryShortCode_contact_info','contact_info_func'));
/* END Contact info */
/* Contact info item */
class WPBakeryShortCode_contact_info_item extends WPBakeryShortCode {
    static function contact_info_item( $atts,  $content ) { 
        return anps_contact_info_item_func($atts, $content);
    }
}
add_shortcode('contact_info_item', array('WPBakeryShortCode_contact_info_item','contact_info_item'));
/* END contact info item */
/* List */
class WPBakeryShortCode_anps_list extends WPBakeryShortCodesContainer {
    static function anps_list_func( $atts,  $content ) {   
        return anps_list_func($atts, $content);
    }
}
add_shortcode('anps_list', array('WPBakeryShortCode_anps_list','anps_list_func'));
/* END List */
/* List item */
class WPBakeryShortCode_anps_list_item extends WPBakeryShortCodesContainer {
    static function anps_list_item_func( $atts,  $content ) {   
        return anps_list_item_func($atts, $content);
    }
}
add_shortcode('list_item', array('WPBakeryShortCode_anps_list_item','anps_list_item_func'));
/* END List item */
/* Opening time */
class WPBakeryShortCode_opening_time extends WPBakeryShortCodesContainer {
    static function opening_time_func( $atts,  $content ) {
        return anps_opening_time_func($atts, $content);
    }
}
add_shortcode('opening_time', array('WPBakeryShortCode_opening_time','opening_time_func'));
/* END Opening time */
/* Opening time item */
class WPBakeryShortCode_opening_time_item extends WPBakeryShortCode {
    static function opening_time_item( $atts,  $content ) { 
        return anps_opening_time_item_func($atts, $content);
    }
}
add_shortcode('opening_time_item', array('WPBakeryShortCode_opening_time_item','opening_time_item'));
/* END Opening time item */
/* Pricing table */
class WPBakeryShortCode_pricing_table extends WPBakeryShortCodesContainer {
    static function pricing_table_func( $atts,  $content ) { 
        return anps_pricing_table_func($atts, $content);
    }
}
add_shortcode('pricing_table', array('WPBakeryShortCode_pricing_table','pricing_table_func'));
/* END Pricing table */
/* Pricing table item */
class WPBakeryShortCode_pricing_item extends WPBakeryShortCode {
    static function pricing_item_func( $atts,  $content ) { 
        return anps_pricing_table_item_func($atts, $content);
    }
}
add_shortcode('pricing_table_item', array('WPBakeryShortCode_pricing_item','pricing_item_func'));
/* END Pricing table item */
/* Statement */
class WPBakeryShortCode_statement extends WPBakeryShortCodesContainer {
    static function statement_func($atts, $content) {
        return anps_statement_func($atts, $content);
    }
}
add_shortcode('statement',array('WPBakeryShortCode_statement','statement_func'));
/* END Statement */
/* Tabs */
class WPBakeryShortCode_tabs extends WPBakeryShortCodesContainer {
    static function tabs_func( $atts,  $content ) {
        return anps_tabs_func($atts, $content);
    }
}
add_shortcode('tabs', array('WPBakeryShortCode_tabs','tabs_func'));
/* END Tabs */
/* Tabs item */
class WPBakeryShortCode_tab extends WPBakeryShortCodesContainer {
    static function tab_func( $atts,  $content ) {
        return anps_tab_func($atts, $content);
    }
}
add_shortcode('tab', array('WPBakeryShortCode_tab','tab_func'));
/* END Tabs item */
/* Testimonials */
class WPBakeryShortCode_testimonials extends WPBakeryShortCodesContainer {
    static  function anps_testimonials_func( $atts,  $content ) { 
        return anps_testimonials($atts, $content);
    }
}
add_shortcode('testimonials', array('WPBakeryShortCode_testimonials','anps_testimonials_func'));
/* END Testimonials */
/* Testimonial item */
class WPBakeryShortCode_anps_testimonial extends WPBakeryShortCode {
    static function anps_testimonial_func( $atts,  $content ) { 
        return anps_testimonial($atts,  $content);
    }
}
add_shortcode('testimonial', array('WPBakeryShortCode_anps_testimonial','anps_testimonial_func'));
/* END Testimonial item */
/* END SHORTCODES */
/* REMOVE VC SHORTCODES */
$vc_values = array(
    'vc_cta_button2',
    'vc_message',
    'vc_facebook',
    'vc_tweetmeme',
    'vc_googleplus',
    'vc_pinterest',
    'vc_toggle',
    'vc_gallery',
    'vc_images_carousel',
    'vc_tour',
    'vc_accordion',
    'vc_posts_grid',
    'vc_carousel',
    'vc_posts_slider',
    'vc_button',
    'vc_cta_button',
    'vc_video',
    'vc_gmaps',
    'vc_raw_js',
    'vc_flickr',
    'vc_progress_bar',
    'vc_pie',
    /* 3rd Party Plugins */
    /* WordPress Widgets */
    'vc_wp_search',
    'vc_wp_meta',
    'vc_wp_recentcomments',
    'vc_wp_calendar',
    'vc_wp_pages',
    'vc_wp_tagcloud',
    'vc_wp_custommenu',
    'vc_wp_text',
    'vc_wp_posts',
    'vc_wp_links',
    'vc_wp_categories',
    'vc_wp_archives',
    'vc_wp_rss'
);
foreach ($vc_values as $vc_value) {
    vc_remove_element($vc_value);
}
/* END REMOVE VC SHORTCODES */
/* NEW PARAMETERS */
/* Portfolio categories new parameter */
function portfolio_categories_settings_field($settings, $value) {   
    $categories = get_terms('portfolio_category');
    $dependency = vc_generate_dependencies_attributes($settings);
    $data = '<select name="'.$settings['param_name'].'" class="wpb_vc_param_value wpb-input wpb-select '.$settings['param_name'].' '.$settings['type'].'">';
    $data .= '<option class="0">'.__("All", ANPS_TEMPLATE_LANG).'</option>';
    foreach($categories as $val) {
        $selected = '';
        if ($value!=='' && $val->term_id === $value) {
             $selected = ' selected="selected"';
        }
        $data .= '<option class="'.$val->term_id.'" value="'.$val->term_id.'"'.$selected.'>'.$val->name.'</option>';
    }
    $data .= '</select>';
    return $data;
}
add_shortcode_param('portfolio_categories' , 'portfolio_categories_settings_field');
/* END NEW PARAMETERS */
/* VC MAP */
/* VC accordion (as parent) */
vc_map( array(
    "name" => __("Accordion/Toggle", ANPS_TEMPLATE_LANG),
    "base" => "accordion",
    "content_element" => true,
    "as_parent" => array('only' => 'accordion_item'),     
    "show_settings_on_create" => true,
    "category" => ANPS_TEMPLATE_LANG,
    "icon" => get_template_directory_uri()."/images/visual-composer/anpsicon_accordion.png",
    "params" => array(
      array(
            "type" => "dropdown",
            "heading" => __("Opened", ANPS_TEMPLATE_LANG),
            "param_name" => "opened",
            "value" =>array(__("No", ANPS_TEMPLATE_LANG)=>'false', __("Yes", ANPS_TEMPLATE_LANG)=>'true'),
            "description" => __("Opened Accordion/Toggle item.", ANPS_TEMPLATE_LANG),
            "save_always" => true
        ),
      array(
            "type" => "dropdown",
            "heading" => __("Type", ANPS_TEMPLATE_LANG),
            "param_name" => "type",
            "value" =>array(__("Accordion", ANPS_TEMPLATE_LANG)=>'', __("Toggle", ANPS_TEMPLATE_LANG)=>'toggle'),
            "description" => __("Accordion type.", ANPS_TEMPLATE_LANG),
            "save_always" => true
        )
    ),
    "js_view" => 'VcColumnView'
) );
/* END VC accordion */
/* VC accordion item (as child) */
vc_map( array(
    "name" => __("Accordion/Toggle item", ANPS_TEMPLATE_LANG),
    "base" => "accordion_item",
    "content_element" => true,
    "is_container" => true,
    "category" => ANPS_TEMPLATE_LANG,
    "icon" => get_template_directory_uri()."/images/visual-composer/anpsicon_accordion.png",
    "as_child" => array('only' => 'accordion'),
    "params" => array(
        array(
            "type" => "textfield",
            "heading" => __("Title", ANPS_TEMPLATE_LANG),
            "param_name" => "title",
            "description" => __("Accordion item title.", ANPS_TEMPLATE_LANG)
        )
    )
) );
/* END VC accordion */
/* VC alert */
vc_map( array(
   "name" => __("Alert", ANPS_TEMPLATE_LANG),
   "base" => "alert",
   "class" => "",
   "icon" => get_template_directory_uri()."/images/visual-composer/anpsicon_alert.png", 
   "category" => ANPS_TEMPLATE_LANG,
   "params" => array(
       array(
         "type" => "textfield",
         "holder" => "div",
         "class" => "",
         "heading" => __("Text", ANPS_TEMPLATE_LANG),
         "param_name" => "content",
         "value" => "", 
         "description" => __("Enter alert text.", ANPS_TEMPLATE_LANG)
       ),
       array(
         "type" => "dropdown",
         "holder" => "div",
         "heading" => __("Icon", ANPS_TEMPLATE_LANG),
         "param_name" => "type",
         "value" => array(__("", ANPS_TEMPLATE_LANG)=>'', __("Warning", ANPS_TEMPLATE_LANG)=>'warning', __("Info", ANPS_TEMPLATE_LANG)=>'info', __("Success", ANPS_TEMPLATE_LANG)=>'success', __("Useful", ANPS_TEMPLATE_LANG)=>'useful', __("Normal", ANPS_TEMPLATE_LANG)=>'normal'),
         "save_always" => true  
       )
       )
    ));
/* END VC alert */
/* VC button */
vc_map( array(
   "name" => __("Button", ANPS_TEMPLATE_LANG),
   "base" => "button",
   "category" => ANPS_TEMPLATE_LANG,
   "icon" => get_template_directory_uri()."/images/visual-composer/anpsicon_button.png", 
   "params" => array(
      array(
         "type" => "textfield",
         "holder" => "div",
         "heading" => __("Text", ANPS_TEMPLATE_LANG),
         "param_name" => "content",
         "description" => __("Enter button text.", ANPS_TEMPLATE_LANG)
      ), 
      array(
         "type" => "textfield",
         "holder" => "div",
         "heading" => __("Link", ANPS_TEMPLATE_LANG),
         "param_name" => "link",
         "value" => "#", 
         "description" => __("Enter button link.", ANPS_TEMPLATE_LANG)
      ), 
      array(
         "type" => "textfield",
         "holder" => "div",
         "heading" => __("Target", ANPS_TEMPLATE_LANG),
         "param_name" => "target",
         "value" => "_self", 
         "description" => __("Enter button target.", ANPS_TEMPLATE_LANG)
      ), 
      array(
         "type" => "dropdown",
         "holder" => "div",
         "heading" => __("Size", ANPS_TEMPLATE_LANG),
         "param_name" => "size",
         "value" => array(__("Small", ANPS_TEMPLATE_LANG)=>'small', __("Medium", ANPS_TEMPLATE_LANG)=>'medium', __("Large", ANPS_TEMPLATE_LANG)=>'large'), 
         "description" => __("Enter button size.", ANPS_TEMPLATE_LANG),
         "save_always" => true 
      ),
      array(
         "type" => "dropdown",
         "holder" => "div",
         "heading" => __("Style", ANPS_TEMPLATE_LANG),
         "param_name" => "style_button",
         "value" => array(__("Style1", ANPS_TEMPLATE_LANG)=>'style-1', __("Style2", ANPS_TEMPLATE_LANG)=>'secondary', __("Style3", ANPS_TEMPLATE_LANG)=>'style-2'), 
         "description" => __("Enter button style.", ANPS_TEMPLATE_LANG),
         "save_always" => true 
      ),
      array(
         "type" => "colorpicker",
         "holder" => "div",
         "heading" => __("Color", ANPS_TEMPLATE_LANG),
         "param_name" => "color",
         "description" => __("Enter button text color.", ANPS_TEMPLATE_LANG)
      ),
      array(
         "type" => "colorpicker",
         "holder" => "div",
         "heading" => __("Background", ANPS_TEMPLATE_LANG),
         "param_name" => "background",
         "description" => __("Enter button background color.", ANPS_TEMPLATE_LANG)
      )
     )
) );
/* END VC button */
/* VC coming soon */
vc_map( array(
   "name" => __("Coming soon", ANPS_TEMPLATE_LANG),
   "base" => "coming_soon",
   "icon" => get_template_directory_uri()."/images/visual-composer/anpsicon_comingsoon.png", 
   "is_container" => true, 
   "category" => ANPS_TEMPLATE_LANG,
   "params" => array(
       array(
         "type" => "textfield",
         "holder" => "div",
         "heading" => __("Subtitle text", ANPS_TEMPLATE_LANG),
         "param_name" => "text"
       ),
       array(
         "type" => "textfield",
         "holder" => "div",
         "heading" => __("Date", ANPS_TEMPLATE_LANG),
         "param_name" => "date"
      ),
      array(
        "type" => "attach_image",
        "heading" => __("Image", ANPS_TEMPLATE_LANG),
        "param_name" => "image_u"
      ),  
      array(
        "type" => "textfield",
        "heading" => __("Image url", ANPS_TEMPLATE_LANG),
        "param_name" => "image",
        "description" => __("Enter image url.", ANPS_TEMPLATE_LANG)
        )
    )
));
/* END VC coming soon */
/* VC Contact */
vc_map( array(
    "name" => __("Contact", ANPS_TEMPLATE_LANG),
    "base" => "contact",
    "content_element" => true,
    "show_settings_on_create" => true,
    "category" => ANPS_TEMPLATE_LANG,
    "as_parent" => array('form_item', 'contact_button'),
    "icon" => get_template_directory_uri()."/images/visual-composer/anpsicon_contact.png",
    "params" => array(
        array(
            "type" => "textfield",
            "heading" => __("Email from", ANPS_TEMPLATE_LANG),
            "param_name" => "email_from",
            "description" => __("Email from.", ANPS_TEMPLATE_LANG)
        ),
        array(
            "type" => "textfield",
            "heading" => __("Subject", ANPS_TEMPLATE_LANG),
            "param_name" => "subject",
            "value" => "This is an awesome email!"
        ),
        array(
            "type" => "textfield",
            "heading" => __("Success message", ANPS_TEMPLATE_LANG),
            "param_name" => "success_msg",
            "value" => "Message sucessfuly sent!"
        ),
        array(
            "type" => "textfield",
            "heading" => __("Error text", ANPS_TEMPLATE_LANG),
            "param_name" => "error_text",
            "value" => "Please insert only letters",
            "description" => __("Error text message.", ANPS_TEMPLATE_LANG)
        ),
        array(
            "type" => "textfield",
            "heading" => __("Error number", ANPS_TEMPLATE_LANG),
            "param_name" => "error_number",
            "value" => "Please insert numbers only",
            "description" => __("Error number message.", ANPS_TEMPLATE_LANG)
        ),
        array(
            "type" => "textfield",
            "heading" => __("Error email", ANPS_TEMPLATE_LANG),
            "param_name" => "error_email",
            "value" => "Please insert a valid email",
            "description" => __("Error email message.", ANPS_TEMPLATE_LANG)
        ),
        array(
            "type" => "textfield",
            "heading" => __("Error phone", ANPS_TEMPLATE_LANG),
            "param_name" => "error_phone",
            "value" => "Please insert a valid phone number",
            "description" => __("Error phone number message.", ANPS_TEMPLATE_LANG)
        ),
        array(
            "type" => "textfield",
            "heading" => __("Error required", ANPS_TEMPLATE_LANG),
            "param_name" => "error_required",
            "value" => "This element is required",
            "description" => __("Error required message.", ANPS_TEMPLATE_LANG)
        )
    ),
    "js_view" => 'VcColumnView'
) );
/* VC END Contact */
/* VC Contact item */
vc_map( array(
    "name" => __("Contact item", ANPS_TEMPLATE_LANG),
    "base" => "form_item",
    "content_element" => true,
    "category" => ANPS_TEMPLATE_LANG,
    "icon" => get_template_directory_uri()."/images/visual-composer/anpsicon_contact.png",
    "as_child" => array('only' => 'contact'),
    "params" => array(
        array(
            "type" => "dropdown",
            "heading" => __("Type", ANPS_TEMPLATE_LANG),
            "param_name" => "type",
            "value" => array(__("Text", ANPS_TEMPLATE_LANG)=>'text', __("Textarea", ANPS_TEMPLATE_LANG)=>'textarea', __("Captcha", ANPS_TEMPLATE_LANG)=>'captcha'),
            "description" => __("Input type.", ANPS_TEMPLATE_LANG),
            "save_always" => true
        ),
        array(
            "type" => "dropdown",
            "heading" => __("Required", ANPS_TEMPLATE_LANG),
            "param_name" => "required",
            "value" => array(__("False", ANPS_TEMPLATE_LANG)=>'false', __("True", ANPS_TEMPLATE_LANG)=>'true'),
            "save_always" => true
       ),
       array(
            "type" => "textfield",
            "heading" => __("Placeholder", ANPS_TEMPLATE_LANG),
            "param_name" => "placeholder"
        ),
        array(
            "type" => "dropdown",
            "heading" => __("Validation", ANPS_TEMPLATE_LANG),
            "param_name" => "validation",
            "value" => array(__("None", ANPS_TEMPLATE_LANG)=>'none', __("Text", ANPS_TEMPLATE_LANG)=>'text', __("Number", ANPS_TEMPLATE_LANG)=>'number', __("Email", ANPS_TEMPLATE_LANG)=>'email', __("Phone", ANPS_TEMPLATE_LANG)=>'phone'),
            "description" => __("Contact form validation.", ANPS_TEMPLATE_LANG),
            "save_always" => true
        ),
        array(
            "type" => "textfield",
            "heading" => __("Rows", ANPS_TEMPLATE_LANG),
            "param_name" => "rows",
            "value" => "5",
            "description" => __("Textarea input field rows.", ANPS_TEMPLATE_LANG)
        )
     )
) );
/* VC END Contact item */
/* VC Contact button */
vc_map( array(
    "name" => __("Contact button", ANPS_TEMPLATE_LANG),
    "base" => "contact_button",
    "content_element" => true,
    "category" => ANPS_TEMPLATE_LANG,
    "as_child" => array('only' => 'contact'),
    "icon" => get_template_directory_uri()."/images/visual-composer/anpsicon_contact.png",
    "show_settings_on_create" => false
) );
/* VC END Contact button */
/* VC contact info */
vc_map( array(
    "name" => __("Contact info", ANPS_TEMPLATE_LANG),
    "base" => "contact_info",
    "as_parent" => array('only' => 'contact_info_item'), 
    "content_element" => true,
    "category" => ANPS_TEMPLATE_LANG,
    "show_settings_on_create" => false,
    "icon" => get_template_directory_uri()."/images/visual-composer/anpsicon_contactinfo.png",
    "js_view" => 'VcColumnView'
) );
/* END VC contact info */
/* VC contact info item */
vc_map( array(
    "name" => __("Contact info item", ANPS_TEMPLATE_LANG),
    "base" => "contact_info_item",
    "content_element" => true,
    "category" => ANPS_TEMPLATE_LANG,
    "icon" => get_template_directory_uri()."/images/visual-composer/anpsicon_contactinfo.png",
    "as_child" => array('only' => 'contact_info'),
    "params" => array(
        array(
            "type" => "textarea_html",
            "heading" => __("Text", ANPS_TEMPLATE_LANG),
            "param_name" => "content",
            "description" => __("Enter text.", ANPS_TEMPLATE_LANG)
        ),
        array(
            "type" => "dropdown",
            "holder" => "div",
            "heading" => __("Icon", ANPS_TEMPLATE_LANG),
            "param_name" => "icon",
            "value" => anps_font_awesome_list(),
            "save_always" => true
      )
    )
) );
/* END VC contact info item */
/* VC dropcaps */
vc_map( array(
   "name" => __("Dropcaps", ANPS_TEMPLATE_LANG),
   "base" => "dropcaps",
   "class" => "",
   "icon" => get_template_directory_uri()."/images/visual-composer/anpsicon_dropcaps.png", 
   "category" => ANPS_TEMPLATE_LANG,
   "params" => array(
       array(
         "type" => "textfield",
         "holder" => "div",
         "class" => "",
         "heading" => __("Dropcaps text", ANPS_TEMPLATE_LANG),
         "param_name" => "content"
      ),
      array(
         "type" => "dropdown",
         "holder" => "div",
         "class" => "",
         "heading" => __("Style", ANPS_TEMPLATE_LANG),
         "param_name" => "style",
         "value" => array(__("Style 1", ANPS_TEMPLATE_LANG)=>'', __("Style 2", ANPS_TEMPLATE_LANG)=>'style-2'),
         "save_always" => true 
       )
   )
) );
/* END VC dropcaps */
/* VC Error 404 */
vc_map( array(
   "name" => __("Error 404", ANPS_TEMPLATE_LANG),
   "base" => "error_404",
   "icon" => get_template_directory_uri()."/images/visual-composer/anpsicon_error404.png", 
   "category" => ANPS_TEMPLATE_LANG,
   "params" => array(
       array(
         "type" => "textfield",
         "holder" => "div",
         "heading" => __("Title", ANPS_TEMPLATE_LANG),
         "param_name" => "title"
       ),
       array(
         "type" => "textfield",
         "holder" => "div",
         "heading" => __("Title large", ANPS_TEMPLATE_LANG),
         "param_name" => "title_large",
         "description" => __("If title exists, title large will be behind title.", ANPS_TEMPLATE_LANG)  
       ),
       array(
         "type" => "textfield",
         "holder" => "div",
         "heading" => __("Subtitle", ANPS_TEMPLATE_LANG),
         "param_name" => "sub_title"
       ),
       array(
         "type" => "textfield",
         "holder" => "div",
         "heading" => __("Button text (go back)", ANPS_TEMPLATE_LANG),
         "param_name" => "content"
      )
    )
));
/* END VC Error 404 */
/* VC Google maps */
vc_map( array(
   "name" => __("Google maps", ANPS_TEMPLATE_LANG),
   "base" => "google_maps",
   "class" => "", 
   "category" => ANPS_TEMPLATE_LANG,
   "icon" => get_template_directory_uri()."/images/visual-composer/anpsicon_googlemaps.png", 
   "params" => array(
      array(
         "type" => "textfield",
         "holder" => "div",
         "class" => "",
         "heading" => __("Location", ANPS_TEMPLATE_LANG),
         "param_name" => "content",
         "value" => "", 
         "description" => __("Enter location.", ANPS_TEMPLATE_LANG)
       ),
       array(
         "type" => "textfield",
         "holder" => "div",
         "class" => "",
         "heading" => __("Zoom", ANPS_TEMPLATE_LANG),
         "param_name" => "zoom",
         "value" => "15", 
         "description" => __("Enter zoom.", ANPS_TEMPLATE_LANG)
       ),
       array(
            "type" => "dropdown",
            "heading" => __("Full width", ANPS_TEMPLATE_LANG),
            "param_name" => "fullwidth",
            "value" =>array(__("No", ANPS_TEMPLATE_LANG)=>'', __("Yes", ANPS_TEMPLATE_LANG)=>'true'),
            "description" => __("Full width.", ANPS_TEMPLATE_LANG),
            "save_always" => true
       ),
       array(
            "type" => "checkbox",
            "heading" => __("Scroll wheel", ANPS_TEMPLATE_LANG),
            "param_name" => "scrollwheel",
            "value" =>"true",
            "save_always" => true
       ),
       array(
            "type" => "checkbox",
            "heading" => __("Draggable", ANPS_TEMPLATE_LANG),
            "param_name" => "draggable",
            "value" =>"true",
            "save_always" => true
       )
     )
) );
/* END VC Google maps */
/* VC heading */
vc_map( array(
   "name" => __("Heading", ANPS_TEMPLATE_LANG),
   "base" => "heading",
   "class" => "",
   "category" => ANPS_TEMPLATE_LANG,
   "icon" => get_template_directory_uri()."/images/visual-composer/anpsicon_heading.png", 
   "params" => array(
      array(
         "type" => "textfield",
         "holder" => "div",
         "class" => "",
         "heading" => __("Title", ANPS_TEMPLATE_LANG),
         "param_name" => "content",
         "value" => "", 
         "description" => __("Enter title.", ANPS_TEMPLATE_LANG)
      ),
      array(
         "type" => "dropdown",
         "holder" => "div",
         "heading" => __("Size", ANPS_TEMPLATE_LANG),
         "param_name" => "size",
         "value" => array(__("*** Select size ***", ANPS_TEMPLATE_LANG)=>'-1', __("H1", ANPS_TEMPLATE_LANG)=>'1', __("H2", ANPS_TEMPLATE_LANG)=>'2', __("H3", ANPS_TEMPLATE_LANG)=>'3', __("H4", ANPS_TEMPLATE_LANG)=>'4', __("H5", ANPS_TEMPLATE_LANG)=>'5'), 
         "description" => __("Enter title size.", ANPS_TEMPLATE_LANG),
         "save_always" => true 
      ),
      array(
         "type" => "dropdown",
         "holder" => "div",
         "heading" => __("Heading class", ANPS_TEMPLATE_LANG),
         "param_name" => "heading_class",
         "value" => array(__("None", ANPS_TEMPLATE_LANG)=>'', __("Style 2", ANPS_TEMPLATE_LANG)=>'style-2', __("Icon", ANPS_TEMPLATE_LANG)=>'icon'), 
         "description" => __("Choose heading.", ANPS_TEMPLATE_LANG),
         "save_always" => true 
      ),
      array(
         "type" => "textfield",
         "holder" => "div",
         "class" => "",
         "heading" => __("Id", ANPS_TEMPLATE_LANG),
         "param_name" => "h_id",
         "value" => "", 
         "description" => __("Enter id.", ANPS_TEMPLATE_LANG)
      ),
      array(
         "type" => "dropdown",
         "holder" => "div",
         "heading" => __("Icon type", ANPS_TEMPLATE_LANG),
         "param_name" => "icon_type",
         "value" => array(__("Svg 1", ANPS_TEMPLATE_LANG)=>'svg1', __("Svg 2", ANPS_TEMPLATE_LANG)=>'svg2', __("Svg 3", ANPS_TEMPLATE_LANG)=>'svg3', __("Icon", ANPS_TEMPLATE_LANG)=>'icon', __("Image", ANPS_TEMPLATE_LANG)=>'image'), 
         "description" => __("Choose icon type.", ANPS_TEMPLATE_LANG),
         "save_always" => true 
      ),
       array(
         "type" => "dropdown",
         "holder" => "div",
         "heading" => __("Icon", ANPS_TEMPLATE_LANG),
         "param_name" => "icon",
         "value" => anps_font_awesome_list(),
         "save_always" => true  
      ),
       array(
         "type" => "textfield",
         "holder" => "div",
         "class" => "",
         "heading" => __("Image url", ANPS_TEMPLATE_LANG),
         "param_name" => "img"
       ),
       array(
         "type" => "attach_image",
         "holder" => "div",
         "heading" => __("Image", ANPS_TEMPLATE_LANG),
         "param_name" => "img_u"
       )  
      )
) );
/* END VC heading */
/* VC icon */
vc_map( array(
   "name" => __("Icon", ANPS_TEMPLATE_LANG),
   "base" => "icon",
   "icon" => get_template_directory_uri()."/images/visual-composer/anpsicon_icon.png", 
   "category" => ANPS_TEMPLATE_LANG,
   "params" => array(
       array(
         "type" => "textfield",
         "holder" => "div",
         "heading" => __("Text", ANPS_TEMPLATE_LANG),
         "param_name" => "content"
      ),
      array(
         "type" => "textfield",
         "holder" => "div",
         "heading" => __("Title", ANPS_TEMPLATE_LANG),
         "param_name" => "title"
      ),
       array(
         "type" => "textfield",
         "holder" => "div",
         "heading" => __("Subtitle", ANPS_TEMPLATE_LANG),
         "param_name" => "subtitle"
      ),
      array(
         "type" => "textfield",
         "holder" => "div",
         "heading" => __("Link", ANPS_TEMPLATE_LANG),
         "param_name" => "url"
      ),
      array(
         "type" => "textfield",
         "holder" => "div",
         "heading" => __("Target", ANPS_TEMPLATE_LANG),
         "param_name" => "target",
         "value" => "_self"
      ),
      array(
         "type" => "dropdown",
         "holder" => "div",
         "heading" => __("Icon", ANPS_TEMPLATE_LANG),
         "param_name" => "icon",
         "value" => anps_font_awesome_list(),
         "save_always" => true 
      )
   )
) );
/* END VC icon */
/* VC list (as parent) */
vc_map( array(
    "name" => __("List", ANPS_TEMPLATE_LANG),
    "base" => "anps_list",
    "content_element" => true,
    "category" => ANPS_TEMPLATE_LANG,
    //"is_container" => true,
    "as_parent" => array('only' => 'list_item'),
    "icon" => get_template_directory_uri()."/images/visual-composer/anpsicon_list.png",
    "js_view" => 'VcColumnView',
    "params" => array(
        array(
            "type" => "dropdown",
            "heading" => __("List icon", ANPS_TEMPLATE_LANG),
            "param_name" => "class",
            "save_always" => true,
            "value" =>array(
                __("Default", ANPS_TEMPLATE_LANG)=>'',
                __("Icons", ANPS_TEMPLATE_LANG)=>'icons',
                __("Hand", ANPS_TEMPLATE_LANG)=>'hand',
                __("Arrow", ANPS_TEMPLATE_LANG)=>'anps_arrow',
                __("Circle check", ANPS_TEMPLATE_LANG)=>'circle-check',
            	__("Number", ANPS_TEMPLATE_LANG)=>'number'),
                "description" => __("Select type. If Icons type selected, you will be able to add different icon to list item.", ANPS_TEMPLATE_LANG)
        )
    )
) );
/* END VC list */
/* VC list item (as child) */
vc_map( array(
    "name" => __("List item", ANPS_TEMPLATE_LANG),
    "base" => "list_item",
    "content_element" => true,
    "category" => ANPS_TEMPLATE_LANG,
    //"is_container" => true,
    "as_child" => array('only' => 'anps_list'),
    "icon" => get_template_directory_uri()."/images/visual-composer/anpsicon_list.png",
    "params" => array(
        array(
         "type" => "textfield",
         "holder" => "div",
         "heading" => __("Text", ANPS_TEMPLATE_LANG),
         "param_name" => "content",
         "description" => __("Enter list text.", ANPS_TEMPLATE_LANG)
       ),
       array(
            "type" => "dropdown",
            "holder" => "div",
            "heading" => __("Icon", ANPS_TEMPLATE_LANG),
            "param_name" => "icon",
            "value" => anps_font_awesome_list(),
            "save_always" => true
      ) 
     )
    ));
/* END VC list item */
/* VC mark */
vc_map( array(
   "name" => __("Color", ANPS_TEMPLATE_LANG),
   "base" => "mark",
   "class" => "",
   "icon" => get_template_directory_uri()."/images/visual-composer/anpsicon_color.png", 
   "category" => ANPS_TEMPLATE_LANG,
   "params" => array(
       array(
         "type" => "textfield",
         "holder" => "div",
         "class" => "",
         "heading" => __("Color text", ANPS_TEMPLATE_LANG),
         "param_name" => "content"
      ),
      array(
         "type" => "dropdown",
         "holder" => "div",
         "class" => "",
         "heading" => __("Style", ANPS_TEMPLATE_LANG),
         "param_name" => "style",
         "value" => array(__("Style 1", ANPS_TEMPLATE_LANG)=>'', __("Style 2", ANPS_TEMPLATE_LANG)=>'style-2'),
         "save_always" => true 
       )
   )
) );
/* END VC mark */
/* VC opening time */
vc_map( array(
    "name" => __("Opening time", ANPS_TEMPLATE_LANG),
    "base" => "opening_time",
    "as_parent" => array('only' => 'opening_time_item'), 
    "content_element" => true,
    "category" => ANPS_TEMPLATE_LANG,
    "icon" => get_template_directory_uri()."/images/visual-composer/anpsicon_openingtime.png",
    "js_view" => 'VcColumnView',
    "params" => array(
        array(
            "type" => "textfield",
            "heading" => __("Title", ANPS_TEMPLATE_LANG),
            "param_name" => "title",
            "description" => __("Enter title.", ANPS_TEMPLATE_LANG)
        )
    )
) );
/* END VC opening time */
/* VC opening time item */
vc_map( array(
    "name" => __("Opening time item", ANPS_TEMPLATE_LANG),
    "base" => "opening_time_item",
    "content_element" => true,
    "category" => ANPS_TEMPLATE_LANG,
    "icon" => get_template_directory_uri()."/images/visual-composer/anpsicon_openingtime.png",
    "as_child" => array('only' => 'opening_time'),
    "params" => array(
        array(
            "type" => "textfield",
            "heading" => __("Day", ANPS_TEMPLATE_LANG),
            "param_name" => "day",
            "description" => __("Enter day.", ANPS_TEMPLATE_LANG)
        ),
        array(
            "type" => "textfield",
            "heading" => __("From", ANPS_TEMPLATE_LANG),
            "param_name" => "from",
            "description" => __("Enter from.", ANPS_TEMPLATE_LANG)
        ),
        array(
            "type" => "textfield",
            "heading" => __("To", ANPS_TEMPLATE_LANG),
            "param_name" => "to",
            "description" => __("Enter to.", ANPS_TEMPLATE_LANG)
        ),
    )
) );
/* END VC opening time item */
/* VC Portfolio */
vc_map( array(
   "name" => __("Portfolio", ANPS_TEMPLATE_LANG),
   "base" => "portfolio",
   "category" => ANPS_TEMPLATE_LANG,
   "icon" => get_template_directory_uri()."/images/visual-composer/anpsicon_portfolio.png", 
   "params" => array(
      array(
         "type" => "textfield",
         "holder" => "div",
         "class" => "",
         "heading" => __("Number of portfolio posts", ANPS_TEMPLATE_LANG),
         "param_name" => "per_page",
         "value" => "", 
         "description" => __("Enter number of portfolio posts.", ANPS_TEMPLATE_LANG)
      ),
      array(
         "type" => "portfolio_categories",
         "holder" => "div",
         "heading" => __("Portfolio categories", ANPS_TEMPLATE_LANG),
         "param_name" => "category",
         "description" => __("Select portfolio categories.", ANPS_TEMPLATE_LANG)
      ),
      array(
         "type" => "dropdown",
         "holder" => "div",
         "heading" => __("Filter", ANPS_TEMPLATE_LANG),
         "param_name" => "filter",
         "value" => array(__("On", ANPS_TEMPLATE_LANG)=>'on', __("Off", ANPS_TEMPLATE_LANG)=>'off'),
         "save_always" => true 
      ),
      array(
         "type" => "dropdown",
         "holder" => "div",
         "class" => "",
         "heading" => __("Order By", ANPS_TEMPLATE_LANG),
         "param_name" => "orderby",
         "value" => array(__("Default", ANPS_TEMPLATE_LANG)=>'', __("Date", ANPS_TEMPLATE_LANG)=>'date', __("Id", ANPS_TEMPLATE_LANG)=>'ID', __("Title", ANPS_TEMPLATE_LANG)=>'title', __("Name", ANPS_TEMPLATE_LANG)=>'name'),  
         "description" => __("Enter order by.", ANPS_TEMPLATE_LANG),
         "save_always" => true 
       ),
       array(
         "type" => "dropdown",
         "holder" => "div",
         "class" => "",
         "heading" => __("Order", ANPS_TEMPLATE_LANG),
         "param_name" => "order",
         "value" => array(__("Default", ANPS_TEMPLATE_LANG)=>'', __("ASC", ANPS_TEMPLATE_LANG)=>'ASC', __("DESC", ANPS_TEMPLATE_LANG)=>'DESC'),
         "save_always" => true  
       )
    )
));
/* END VC Portfolio */
/* VC Pricing table */
vc_map( array(
    "name" => __("Pricing table", ANPS_TEMPLATE_LANG),
    "base" => "pricing_table",
    "content_element" => true,
    "category" => ANPS_TEMPLATE_LANG,
    "as_parent" => array('only' => 'pricing_table_item'),
    "icon" => get_template_directory_uri()."/images/visual-composer/anpsicon_pricingtable.png",
    "params" => array(
        array(
         "type" => "textfield",
         "holder" => "div",
         "heading" => __("Title", ANPS_TEMPLATE_LANG),
         "param_name" => "title",
         "description" => __("Enter pricing table title.", ANPS_TEMPLATE_LANG)
       ),
       array(
         "type" => "textfield",
         "holder" => "div",
         "heading" => __("Currency", ANPS_TEMPLATE_LANG),
         "param_name" => "currency",
         "value" => "",
         "description" => __("Enter currency symbol.", ANPS_TEMPLATE_LANG)
       ),
       array(
         "type" => "textfield",
         "holder" => "div",
         "heading" => __("Price", ANPS_TEMPLATE_LANG),
         "param_name" => "price",
         "value" => "0",  
         "description" => __("Enter price.", ANPS_TEMPLATE_LANG)
       ),
       array(
         "type" => "textfield",
         "holder" => "div",
         "heading" => __("Period", ANPS_TEMPLATE_LANG),
         "param_name" => "period",
         "description" => __("Enter period (optional).", ANPS_TEMPLATE_LANG)
       ),
        array(
         "type" => "textfield",
         "holder" => "div",
         "heading" => __("Button Text", ANPS_TEMPLATE_LANG),
         "param_name" => "button_text",
         "description" => __("Enter pricing table button text.", ANPS_TEMPLATE_LANG)
        ),
        array(
         "type" => "textfield",
         "holder" => "div",
         "heading" => __("Button Url", ANPS_TEMPLATE_LANG),
         "param_name" => "button_url",
         "description" => __("Enter pricing table button url.", ANPS_TEMPLATE_LANG)
        ),
        array(
         "type" => "dropdown",
         "holder" => "div",
         "class" => "",
         "heading" => __("Featured", ANPS_TEMPLATE_LANG),
         "param_name" => "featured",
         "value" => array(__("No", ANPS_TEMPLATE_LANG)=>'', __("Yes", ANPS_TEMPLATE_LANG)=>'yes'),
         "save_always" => true   
       )
    ),
    "js_view" => 'VcColumnView'
) );
/* END VC Pricing table */
/* VC Pricing item */
vc_map( array(
    "name" => __("Pricing item", ANPS_TEMPLATE_LANG),
    "base" => "pricing_table_item",
    "content_element" => true,
    "is_container" => true,
    "category" => ANPS_TEMPLATE_LANG,
    "as_child" => array('only' => 'pricing_table'),
    "icon" => get_template_directory_uri()."/images/visual-composer/anpsicon_pricingtable.png",
    "params" => array(
        array(
         "type" => "textfield",
         "holder" => "div",
         "heading" => __("Text", ANPS_TEMPLATE_LANG),
         "param_name" => "content",
         "description" => __("Enter pricing item text.", ANPS_TEMPLATE_LANG)
       )
     )
    ));
/* END VC Pricing item */
/* VC quote */
vc_map( array(
   "name" => __("Quote", ANPS_TEMPLATE_LANG),
   "base" => "quote",
   "class" => "",
   "icon" => get_template_directory_uri()."/images/visual-composer/anpsicon_quote.png", 
   "category" => ANPS_TEMPLATE_LANG,
   "params" => array(
       array(
         "type" => "textfield",
         "holder" => "div",
         "class" => "",
         "heading" => __("Quote text", ANPS_TEMPLATE_LANG),
         "param_name" => "content"
      )
   )
) );
/* END VC quote */
/* VC Statement */
vc_map( array(
   "name" => __("Statement", ANPS_TEMPLATE_LANG),
   "base" => "statement",
   "content_element" => true,
   "is_container" => true, 
   "category" => ANPS_TEMPLATE_LANG,
   "js_view" => 'VcColumnView', 
   "as_parent" => array(), 
   "icon" => get_template_directory_uri()."/images/visual-composer/anpsicon_statement.png", 
   "params" => array(
       array(
         "type" => "textfield",
         "holder" => "div",
         "class" => "",
         "heading" => __("Slug", ANPS_TEMPLATE_LANG),
         "param_name" => "slug",
         "description" => __("This is used for both for none page navigation and the parallax effect (if you do not have the navigation need you enter a unique slug if you want parallax effect to function)", ANPS_TEMPLATE_LANG)  
       ),
       array(
         "type" => "dropdown",
         "holder" => "div",
         "class" => "",
         "heading" => __("Parallax", ANPS_TEMPLATE_LANG),
         "param_name" => "parallax",
         "value" => array(__("False", ANPS_TEMPLATE_LANG)=>'false', __("True", ANPS_TEMPLATE_LANG)=>'true'), 
         "description" => __("Enter parallax.", ANPS_TEMPLATE_LANG),
         "save_always" => true  
       ),
       array(
         "type" => "dropdown",
         "holder" => "div",
         "class" => "",
         "heading" => __("Parallax overlay", ANPS_TEMPLATE_LANG),
         "param_name" => "parallax_overlay",
         "value" => array(__("False", ANPS_TEMPLATE_LANG)=>'', __("True", ANPS_TEMPLATE_LANG)=>'true'), 
         "description" => __("Parallax overlay.", ANPS_TEMPLATE_LANG),
         "save_always" => true  
       ),
       array(
         "type" => "textfield",
         "holder" => "div",
         "class" => "",
         "heading" => __("Background image url", ANPS_TEMPLATE_LANG),
         "param_name" => "image"
       ),
       array(
         "type" => "attach_image",
         "holder" => "div",
         "heading" => __("Background image", ANPS_TEMPLATE_LANG),
         "param_name" => "image_u"
       ),
       array(
         "type" => "colorpicker",
         "holder" => "div",
         "heading" => __("Background color", ANPS_TEMPLATE_LANG),
         "param_name" => "color",
         "value" => "", 
         "description" => __("Background color.", ANPS_TEMPLATE_LANG)
       ),
       array(
         "type" => "dropdown",
         "holder" => "div",
         "class" => "",
         "heading" => __("Container", ANPS_TEMPLATE_LANG),
         "param_name" => "container",
         "value" => array(__("False", ANPS_TEMPLATE_LANG)=>'', __("True", ANPS_TEMPLATE_LANG)=>'true'), 
         "description" => __("Container around statement.", ANPS_TEMPLATE_LANG),
         "save_always" => true  
       )
   )
) );
/* END VC statement */
/* VC recent blog */
vc_map( array(
   "name" => __("Recent blog", ANPS_TEMPLATE_LANG),
   "base" => "recent_blog",
   "class" => "",
   "category" => ANPS_TEMPLATE_LANG,
   "icon" => get_template_directory_uri()."/images/visual-composer/anpsicon_recentblog.png", 
   "params" => array(
      array(
         "type" => "textfield",
         "holder" => "div",
         "class" => "",
         "heading" => __("Number of blog posts", ANPS_TEMPLATE_LANG),
         "param_name" => "number",
         "value" => "3", 
         "description" => __("Enter number of recent blog posts.", ANPS_TEMPLATE_LANG)
      ) 
       )
) );
/* END VC recent blog */
/* VC recent portfolio */
vc_map( array(
   "name" => __("Recent portfolio", ANPS_TEMPLATE_LANG),
   "base" => "recent_portfolio",
   "class" => "",
   "category" => ANPS_TEMPLATE_LANG,
   "icon" => get_template_directory_uri()."/images/visual-composer/anpsicon_recentportfolio.png", 
   "params" => array(
      array(
         "type" => "textfield",
         "holder" => "div",
         "class" => "",
         "heading" => __("Number of portfolio posts", ANPS_TEMPLATE_LANG),
         "param_name" => "number",
         "value" => "6", 
         "description" => __("Enter number of recent portfolio posts.", ANPS_TEMPLATE_LANG)
      ),
      array(
         "type" => "portfolio_categories",
         "holder" => "div",
         "heading" => __("Portfolio categories", ANPS_TEMPLATE_LANG),
         "param_name" => "category",
         "description" => __("Select portfolio categories.", ANPS_TEMPLATE_LANG)
      ),
      array(
            "type" => "dropdown",
            "heading" => __("AJAX", ANPS_TEMPLATE_LANG),
            "param_name" => "ajax",
            "value" =>array(__("OFF", ANPS_TEMPLATE_LANG)=>'false', __("ON", ANPS_TEMPLATE_LANG)=>'true'),
            "description" => __("If set to ON, the posts will open in a pop-up.", ANPS_TEMPLATE_LANG),
            "save_always" => true
        ),
       )
) );
/* END VC recent bportfolio */
/* VC testimonials (as parent) */
vc_map( array(
    "name" => __("Testimonials", ANPS_TEMPLATE_LANG),
    "base" => "testimonials",
    "as_parent" => array('only' => 'testimonial'), 
    "content_element" => true,
    "category" => ANPS_TEMPLATE_LANG,
    "show_settings_on_create" => false,
    "icon" => get_template_directory_uri()."/images/visual-composer/anpsicon_testimonials.png",
    "js_view" => 'VcColumnView'
) );
/* END VC testimonials */
/* VC testimonial (as child) */
vc_map( array(
    "name" => __("Testimonial item", ANPS_TEMPLATE_LANG),
    "base" => "testimonial",
    "content_element" => true,
    "category" => ANPS_TEMPLATE_LANG,
    "icon" => get_template_directory_uri()."/images/visual-composer/anpsicon_testimonials.png",
    "as_child" => array('only' => 'testimonials'),
    "params" => array(  
        array(
            "type" => "textarea",
            "heading" => __("Testimonial text", ANPS_TEMPLATE_LANG),
            "param_name" => "content",
            "description" => __("Enter user testimonial text", ANPS_TEMPLATE_LANG)
        ),
        array(
            "type" => "textfield",
            "heading" => __("User", ANPS_TEMPLATE_LANG),
            "param_name" => "user",
            "description" => __("Enter user", ANPS_TEMPLATE_LANG)
        ),
        array(
            "type" => "textfield",
            "heading" => __("Title", ANPS_TEMPLATE_LANG),
            "param_name" => "title",
            "description" => __("Enter title", ANPS_TEMPLATE_LANG)
        )
    )
) );
/* END VC testimonial */
/* VC twitter */
vc_map( array(
   "name" => __("Twitter", ANPS_TEMPLATE_LANG),
   "base" => "twitter",
   "class" => "",
   "icon" => get_template_directory_uri()."/images/visual-composer/anpsicon_twitter.png", 
   "category" => ANPS_TEMPLATE_LANG,
   "params" => array(
       array(
         "type" => "textfield",
         "holder" => "div",
         "class" => "",
         "heading" => __("Slug", ANPS_TEMPLATE_LANG),
         "param_name" => "slug",
         "description" => __("This is used for both for none page navigation and the parallax effect (if you do not have the navigation need you enter a unique slug if you want parallax effect to function)", ANPS_TEMPLATE_LANG)  
       ),
       array(
         "type" => "textfield",
         "holder" => "div",
         "class" => "",
         "heading" => __("Title", ANPS_TEMPLATE_LANG),
         "param_name" => "title",
         "value" => "Stay tuned, follow us on Twitter", 
         "description" => __("Enter twitter title.", ANPS_TEMPLATE_LANG)
       ),
       array(
         "type" => "dropdown",
         "holder" => "div",
         "class" => "",
         "heading" => __("Parallax", ANPS_TEMPLATE_LANG),
         "param_name" => "parallax",
         "value" => array(__("False", ANPS_TEMPLATE_LANG)=>'false', __("True", ANPS_TEMPLATE_LANG)=>'true'), 
         "description" => __("Enter parallax.", ANPS_TEMPLATE_LANG),
         "save_always" => true  
       ),
       array(
         "type" => "dropdown",
         "holder" => "div",
         "class" => "",
         "heading" => __("Parallax overlay", ANPS_TEMPLATE_LANG),
         "param_name" => "parallax_overlay",
         "value" => array(__("False", ANPS_TEMPLATE_LANG)=>'', __("True", ANPS_TEMPLATE_LANG)=>'true'), 
         "description" => __("Parallax overlay.", ANPS_TEMPLATE_LANG),
         "save_always" => true  
       ),
       array(
         "type" => "textfield",
         "holder" => "div",
         "class" => "",
         "heading" => __("Background image url", ANPS_TEMPLATE_LANG),
         "param_name" => "image",
         "description" => __("Enter background image url.", ANPS_TEMPLATE_LANG)
       ),
       array(
         "type" => "attach_image",
         "holder" => "div",
         "heading" => __("Background image", ANPS_TEMPLATE_LANG),
         "param_name" => "image_u"
       ),
       array(
         "type" => "colorpicker",
         "holder" => "div",
         "heading" => __("Background color", ANPS_TEMPLATE_LANG),
         "param_name" => "color",
         "value" => "", 
         "description" => __("Background color.", ANPS_TEMPLATE_LANG)
       ),
       array(
         "type" => "textfield",
         "holder" => "div",
         "class" => "",
         "heading" => __("Twitter username", ANPS_TEMPLATE_LANG),
         "param_name" => "content",
         "value" => "", 
         "description" => __("Enter twitter username.", ANPS_TEMPLATE_LANG)
      )
       )
) );
/* END VC twitter */
/* VC vimeo */
vc_map( array(
   "name" => __("Vimeo", ANPS_TEMPLATE_LANG),
   "base" => "vimeo",
   "class" => "",
   "icon" => get_template_directory_uri()."/images/visual-composer/anpsicon_vimeo.png", 
   "category" => ANPS_TEMPLATE_LANG,
   "params" => array(
      array(
         "type" => "textfield",
         "holder" => "div",
         "class" => "",
         "heading" => __("Video id", ANPS_TEMPLATE_LANG),
         "param_name" => "content",
         "value" => "", 
         "description" => __("Enter vimeo video id.", ANPS_TEMPLATE_LANG)
      ) 
       )
) );
/* END VC vimeo */
/* VC youtube */
vc_map( array(
   "name" => __("Youtube", ANPS_TEMPLATE_LANG),
   "base" => "youtube",
   "class" => "",
   "icon" => "icon-wpb-film-youtube", 
   "category" => ANPS_TEMPLATE_LANG,
   "params" => array(
      array(
         "type" => "textfield",
         "holder" => "div",
         "class" => "",
         "heading" => __("Video id", ANPS_TEMPLATE_LANG),
         "param_name" => "content",
         "value" => "", 
         "description" => __("Enter youtube video id.", ANPS_TEMPLATE_LANG)
      ) 
       )
) );
/* END VC youtube */
/* END VC MAP */
/* VC parameters */
/* Add parameter vc_row */
vc_add_param('vc_row', array("type" => "textfield", 'heading'=>__("Id", ANPS_TEMPLATE_LANG), 'param_name' =>'id'));
if(get_option("anps_vc_legacy", "0"=="on")) {
    vc_add_param('vc_row', array("type" => "dropdown", 'heading'=>__("Content wrapper", ANPS_TEMPLATE_LANG), 'param_name' =>'has_content', "value" =>array(__("On", ANPS_TEMPLATE_LANG)=>'true', __("Off", ANPS_TEMPLATE_LANG)=>'false', __("Inside content wrapper", ANPS_TEMPLATE_LANG)=>'inside'))); 
    /* Add parameter vc_row_inner */
    vc_add_param('vc_row_inner', array("type" => "dropdown", 'heading'=>__("Content wrapper", ANPS_TEMPLATE_LANG), 'param_name' =>'has_content', "value" =>array(__("On", ANPS_TEMPLATE_LANG)=>'true', __("Off", ANPS_TEMPLATE_LANG)=>'false'), __("Inside content wrapper", ANPS_TEMPLATE_LANG)=>'inside')); 
}
/* Add parameter vc_tabs */
vc_add_param('vc_tta_tabs', array("type" => "dropdown", 'heading'=>__("Type", ANPS_TEMPLATE_LANG), 'param_name' =>'type', "value" =>array(__("Horizontal", ANPS_TEMPLATE_LANG)=>'', __("Vertical", ANPS_TEMPLATE_LANG)=>'vertical')));
vc_add_param('vc_tabs', array("type" => "dropdown", 'heading'=>__("Type", ANPS_TEMPLATE_LANG), 'param_name' =>'type', "value" =>array(__("Horizontal", ANPS_TEMPLATE_LANG)=>'', __("Vertical", ANPS_TEMPLATE_LANG)=>'vertical')));
/* Add anps style to backend vc_tta_tabs dropdown */
vc_add_param('vc_tta_tabs', array(
    "type" => "dropdown",
    "heading" => __( 'Style', 'js_composer' ),
    'param_name' =>'style', 
    'value' => array(
                __( 'Anpsthemes', 'js_composer' ) => 'anps_tabs',
                __( 'Classic', 'js_composer' ) => 'classic',
                __( 'Modern', 'js_composer' ) => 'modern',
                __( 'Flat', 'js_composer' ) => 'flat',
                __( 'Outline', 'js_composer' ) => 'outline',
        ),
    'description' => __( 'Select tabs display style.', 'js_composer' )
    )
);
/* Add anps style to backend vc_tta_accordion dropdown */
vc_add_param('vc_tta_accordion', array(
    "type" => "dropdown",
    "heading" => __( 'Style', 'js_composer' ),
    'param_name' =>'style', 
    'value' => array(
                __( 'Anpsthemes', 'js_composer' ) => 'anps_accordion',
                __( 'Classic', 'js_composer' ) => 'classic',
                __( 'Modern', 'js_composer' ) => 'modern',
                __( 'Flat', 'js_composer' ) => 'flat',
                __( 'Outline', 'js_composer' ) => 'outline',
        ),
    'description' => __( 'Select accordion display style.', 'js_composer' )
    )
);