<?php
add_action('add_meta_boxes', 'anps_page_add_custom_box');
add_action('save_post', 'anps_page_save_postdata');

function anps_page_add_custom_box() { 
    $screens = array( 'page' );
    foreach($screens as $screen) {
        add_meta_box('anps_page_type_meta', __('Page settings', ANPS_TEMPLATE_LANG), 'display_page_data', $screen, 'side', 'core');
        add_meta_box('anps_footer_type_meta', __('Footer settings', ANPS_TEMPLATE_LANG), 'display_footer_options', $screen, 'side', 'core');
    }
    add_meta_box('anps_footer_type_meta', __('Footer settings', ANPS_TEMPLATE_LANG), 'display_footer_options', 'post', 'side', 'core');
}

function display_page_data( $post ) { 
    $page_value = get_post_meta($post->ID, $key ='anps_page_type', $single = true ); 
    $page_cat = get_post_meta($post->ID, $key ='anps_page_cat', $single = true );
    $page_blog = get_post_meta($post->ID, $key ='anps_page_blog', $single = true );
    $page_types = array(1=>"1 column", 2=>"3 columns", 3=>"4 columns", 4=>"Masonry 3 columns", 5=>"Masonry 4 columns");
    ob_start();
    wp_category_checklist(0, 0, $page_cat, false, null, false);
    $cat_data = ob_get_clean();
    if($page_blog=="on") {
        $checked = "checked";
        $class = "";
    } else {
        $checked = "";
        $class = " hidden";
    } ?>
    <script>
        jQuery(function($) {
            $("#anps_page_blog").change(function(){
                var page_blog = $(this).attr("checked"); 
                if(page_blog=="checked") {
                    $(".anps_blog").removeClass("hidden");
                } else {
                    $(".anps_blog").addClass("hidden");
                }
            }); 
        });
    </script>
    <?php
    $data = "";
    $data .= "<p><strong>".__("Set this page as blog", ANPS_TEMPLATE_LANG)."</strong> <input type='checkbox' id='anps_page_blog' name='anps_page_blog' $checked/></p>";
    $data .= "<p class='anps_blog$class'><strong>".__("Type", ANPS_TEMPLATE_LANG)."</strong></p>";
    $data .= "<select class='anps_blog$class' name='anps_page_type'>";
    $data .= "<option value='0'>*** Select ***</option>";
    foreach($page_types as $key=>$value) {
        if($key==$page_value) {
            $selected = " selected";
        } else {
            $selected = "";
        }
        $data .= "<option value='".$key."'$selected>".$value."</option>";
    }
    $data .= "</select>";
    $data .= "<p class='anps_blog$class'><strong>".__("Categories", ANPS_TEMPLATE_LANG)."</strong></p>";
    $data .= "<ul class='anps_blog categorychecklist form-no-clear$class' data-wp-lists='list:category' id='categorychecklist'>";
    $data .= $cat_data;
    $data .= "</ul>";
    echo $data;
}

function display_footer_options($post) {
    $footer_value = get_post_meta($post->ID, $key ='anps_footer_type', $single = true );
    $footer_disable = get_post_meta($post->ID, $key ='anps_footer_disable', $single = true );
    if($footer_disable=="on") {
        $checked = "checked";
        $class = " hidden";
    } else {
        $checked = "";
        $class = "";
    } ?>
    <script>
    jQuery(function($) {
        $("#anps_footer_disable").change(function(){
            var footer_disable = $(this).attr("checked"); 
            if(footer_disable=="checked") {
                $(".anps_footer").addClass("hidden");
            } else {
                $(".anps_footer").removeClass("hidden");
            }
        }); 
    });
    </script>
    <?php $footer_types = array(2=>"2 columns", 3=>"3 columns", 4=>"4 columns");
    $data = "";
    $data .= "<p><strong>".__("Disable footer", ANPS_TEMPLATE_LANG)."</strong> <input type='checkbox' id='anps_footer_disable' name='anps_footer_disable' $checked/></p>";
    $data .= "<select class='anps_footer$class' name='anps_footer_type'>";
    $data .= "<option value='0'>*** Select ***</option>";
    foreach($footer_types as $key=>$value) {
        if($key==$footer_value) {
            $selected = " selected";
        } else {
            $selected = "";
        }
        $data .= "<option value='".$key."'$selected>".$value."</option>";
    }
    $data .= "</select>";
    echo $data;
}

function anps_page_save_postdata($post_id) { 
    if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) { 
        return;
    }
    if (empty($_POST) || !isset($_POST['post_ID'])) {
        return;
    }

    $post_ID = $_POST['post_ID'];

    if (!isset($_POST['anps_page_type'])) {
        $_POST['anps_page_type'] = '0';
    }
    if (!isset($_POST['post_category'])) {
        $_POST['post_category'] = '';
    }
    if (!isset($_POST['anps_page_blog'])) {
        $_POST['anps_page_blog'] = '';
    }
    if (!isset($_POST['anps_footer_type'])) {
        $_POST['anps_footer_type'] = '';
    }
    if (!isset($_POST['anps_footer_disable'])) {
        $_POST['anps_footer_disable'] = '';
    }
    $mydata2 = $_POST['anps_page_type'];  
    $anps_page_cat = $_POST['post_category'];
    $anps_page_blog = $_POST['anps_page_blog'];

    add_post_meta($post_ID, 'anps_page_type', $mydata2, true) or update_post_meta($post_ID, 'anps_page_type', $mydata2);
    add_post_meta($post_ID, 'anps_page_cat', $anps_page_cat, true) or update_post_meta($post_ID, 'anps_page_cat', $anps_page_cat);
    add_post_meta($post_ID, 'anps_page_blog', $anps_page_blog, true) or update_post_meta($post_ID, 'anps_page_blog', $anps_page_blog);
    add_post_meta($post_ID, 'anps_footer_type', $_POST['anps_footer_type'], true) or update_post_meta($post_ID, 'anps_footer_type', $_POST['anps_footer_type']);
    add_post_meta($post_ID, 'anps_footer_disable', $_POST['anps_footer_disable'], true) or update_post_meta($post_ID, 'anps_footer_disable', $_POST['anps_footer_disable']);
}
