<?php
include_once 'classes/Options.php';

$anps_options_data = $options->get_page_data();  
if (isset($_GET['save_page']))
  $options->save_page();
?>
<form action="themes.php?page=theme_options&sub_page=options_page&save_page" method="post">

    <div class="content-top"><input type="submit" value="<?php _e("Save all changes", ANPS_TEMPLATE_LANG); ?>" /><div class="clear"></div></div>

    <div class="content-inner">
        <!-- Page layout -->
        <h3><?php _e("Page layout:", ANPS_TEMPLATE_LANG); ?></h3>
        <p><?php _e("Here you can change all the settings about responsive layout and will your site be boxed (when checked you will have more options).", ANPS_TEMPLATE_LANG); ?></p>        
        <div class="info">
            <!-- Responsive -->
            <div class="input">
                <?php
                if(!isset($anps_options_data['responsive']))
                    $checked='';
                elseif ($anps_options_data['responsive'] == '-1')
                    $checked = '';
                elseif ($anps_options_data['responsive'] == '')
                    $checked = '';
                else
                    $checked = 'checked';
                ?>
                <label for="responsive"><?php _e("Disable Responsive", ANPS_TEMPLATE_LANG); ?></label>
                <input class="small_input" style="margin-left: 74px" type="checkbox" name="responsive" <?php echo $checked; ?> />
            </div>
            <!-- Disable page title, breadcrumbs and background -->
            <div class="input">
                <?php 
                if(!isset($anps_options_data['disable_heading']))
                    $checked='';
                elseif ($anps_options_data['disable_heading'] == '-1')
                    $checked = '';
                elseif ($anps_options_data['disable_heading'] == '')
                    $checked = '';
                else
                    $checked = 'checked';
                ?>
                <label for="disable_heading"><?php _e("Disable page title, breadcrumbs and background", ANPS_TEMPLATE_LANG); ?></label>
                <input class="small_input" style="margin-left: 74px" type="checkbox" name="disable_heading" <?php echo $checked; ?> />
            </div>
            <!-- END Disable page title, breadcrumbs and background --> 
            <!-- Breadcrumbs disable -->
            <div class="input">
                <?php 
                if(!isset($anps_options_data['breadcrumbs']))
                    $checked='';
                elseif ($anps_options_data['breadcrumbs'] == '-1')
                    $checked = '';
                elseif ($anps_options_data['breadcrumbs'] == '')
                    $checked = '';
                else
                    $checked = 'checked';
                ?>
                <label for="breadcrumbs"><?php _e("Disable breadcrumbs", ANPS_TEMPLATE_LANG); ?></label>
                <input class="small_input" style="margin-left: 74px" type="checkbox" name="breadcrumbs" <?php echo $checked; ?> />
            </div>
            <!-- END Breadcrumbs disable --> 

            <!-- Boxed -->
            <div class="input">
                <?php
                if(!isset($anps_options_data['boxed']))
                    $checked='';
                elseif ($anps_options_data['boxed'] == '-1')
                    $checked = '';
                elseif ($anps_options_data['boxed'] == '')
                    $checked = '';
                else
                    $checked = 'checked';
                ?>
                <label for="boxed"><?php _e("Boxed", "shopbox"); ?></label>
                <input id="is-boxed" class="small_input" style="margin-left: 74px" type="checkbox" name="boxed" <?php echo $checked; ?> />

            </div>
            <!-- Pattern -->
            <div <?php if ($checked == "") echo 'style="display:none"'; ?> class="input" id="pattern-select-wrapper">
                <label for="pattern"><?php _e("Pattern", "shopbox"); ?></label>
                <div class="admin-patern-radio">
                    <?php for ($i = 0; $i < 10; $i++) :
                        if ($anps_options_data['pattern'] == $i)
                            $checked = 'checked';
                        else
                            $checked = '';
                        ?>
                        <input type="radio" name="pattern" value="<?php echo $i; ?>" <?php echo $checked; ?>/>
                    <?php endfor; ?>
                </div>
                <div class="admin-patern-select">
                    <?php for ($i = 0; $i < 10; $i++) : ?>
                        <?php if ($anps_options_data['pattern'] == $i): ?>
                            <img id="selected-pattern" src="<?php echo get_stylesheet_directory_uri(); ?>/css/boxed/pattern-<?php echo $i; ?>.png" />
                        <?php else: ?>
                            <img src="<?php echo get_stylesheet_directory_uri(); ?>/css/boxed/pattern-<?php echo $i; ?>.png" />
                        <?php endif; ?>
                    <?php endfor; ?>
                </div>
                <div style="clear: both"></div>
            </div>
            <!-- Custom background -->
            <div class="input" <?php if (!isset($anps_options_data['boxed']) || $anps_options_data['pattern'] != 0 || $anps_options_data['boxed'] == '-1' || $anps_options_data['boxed'] == '') echo 'style="display: none"'; ?> id="patern-type-wrapper">
                <label for="pattern"><?php _e("Custom background type", "shopbox"); ?></label>
                <div class="patern-type">
                    <?php $types = array('stretched', 'tilled', 'custom color');
                    foreach ($types as $type) :
                        if(!isset($anps_options_data['type']))
                            $checked='';
                        elseif ($anps_options_data['type'] == $type)
                            $checked = 'checked';
                        else
                            $checked = '';
                        ?>
                        <input style="display: inline-block;" type="radio" id="back-type-<?php echo $type; ?>" name="type" value="<?php echo $type; ?>" <?php echo $checked; ?>/>
                        <label style="font-weight: normal;display: inline; margin: 0; cursor: pointer" for="back-type-<?php echo $type; ?>"><?php echo $type; ?></label>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                    <?php endforeach; ?>
                </div>
            </div>
            <!-- Custom pattern -->
            <div class="input"  <?php if ((!isset($anps_options_data['boxed']) || $anps_options_data['pattern'] != 0 || $anps_options_data['boxed'] == '-1' || $anps_options_data['boxed'] == '') || ($anps_options_data['type'] != "stretched") && $anps_options_data['type'] != "tilled" ) echo 'style="display: none"'; ?> id="custom-patern-wrapper">
                <label for="custom_pattern"><?php _e("Custom background image/pattern", "shopbox"); ?></label>
                <input id="custom_pattern" type="text" size="36" name="custom_pattern" value="<?php echo $anps_options_data['custom_pattern']; ?>" />
                <input id="_btn" class="upload_image_button" type="button" value="Upload" />
            </div>
            <!-- Custom background color -->

            <div id="custom-background-color-wrapper" class="input" <?php if ((!isset($anps_options_data['boxed']) || $anps_options_data['pattern'] != 0 || $anps_options_data['boxed'] == '-1' || $anps_options_data['boxed'] == '') || (!isset($anps_options_data['type']) || $anps_options_data['type'] != "custom color") ) echo 'style="display: none"'; ?>>
                <label for="bg_color"><?php _e("Custom background color", "shopbox"); ?></label>
                <input data-value="<?php echo $anps_options_data['bg_color']; ?>" readonly style="background: <?php echo $anps_options_data['bg_color']; ?>" class="color-pick-color"><input class="color-pick" type="text" name="bg_color" value="<?php echo $anps_options_data['bg_color']; ?>" id="bg_color" />
            </div>

            <!-- Hide slider on mobile -->
            <div class="input">
                <?php
                if(!isset($anps_options_data['hide_slider_on_mobile']))
                    $checked='';
                elseif ($anps_options_data['hide_slider_on_mobile'] == '-1')
                    $checked = '';
                elseif ($anps_options_data['hide_slider_on_mobile'] == '')
                    $checked = '';
                else
                    $checked = 'checked';
                ?>
                <label for="hide_slider_on_mobile"><?php _e("Hide slider on mobile", "altus"); ?></label>
                <input id="hide_slider_on_mobile" class="small_input" style="margin-left: 74px" type="checkbox" name="hide_slider_on_mobile" <?php echo $checked; ?> />

            </div>
    </div>
</div>

<div class="content-top" style="border-style: solid none; margin-top: 70px">
    <input type="submit" value="<?php _e("Save all changes", ANPS_TEMPLATE_LANG); ?>">
    <div class="clear"></div>
</div>
</form>

<?php
wp_enqueue_script('media-upload');
    wp_enqueue_script('thickbox');
    wp_register_script('my-upload', get_template_directory_uri() . '/anps-framework/js/upload_image.js', array('jquery', 'media-upload', 'thickbox'));
    wp_enqueue_script('my-upload');
    wp_enqueue_style('thickbox');
    if (isset($_GET['save_page'])) {
      //update_option("rtl", $_POST['rtl']);
    }