<?php 
include_once 'classes/Options.php';
$anps_page_data = $options->get_page_setup_data();
if (isset($_GET['save_page_setup'])) {  
    $options->save_page_setup();
}
?>
<form action="themes.php?page=theme_options&sub_page=options_page_setup&save_page_setup" method="post">
        <div class="content-top"><input type="submit" value="<?php _e("Save all changes", ANPS_TEMPLATE_LANG); ?>" />
                <div class="clear"></div>
        </div>
        <div class="content-inner">
        <!-- Page setup -->
        <h3><?php _e("Page setup:", ANPS_TEMPLATE_LANG); ?></h3>
        <!-- Coming soon page -->
        <div class="input">
        <label for="coming_soon">
        <?php _e("Coming soon page", ANPS_TEMPLATE_LANG); ?></label>
        <select name="coming_soon">
                <option value="0">*** Select ***</option>
                <?php 
                        $pages = get_pages();
                        foreach ($pages as $item) :
                                if ($anps_page_data['coming_soon'] == $item->ID) {
                                        $selected = 'selected="selected"';
                                }
                                else {         
                                        $selected = '';
                                }
                ?>      <option value="<?php echo $item->ID; ?>" <?php echo $selected; ?>><?php echo $item->post_title; ?></option>                 
                <?php endforeach; ?>            
        </select>        
        </div>
        <!-- Error page -->
        <div class="input">
        <label for="error_page">
        <?php _e("404 error page", ANPS_TEMPLATE_LANG); ?></label>
        <select name="error_page">
                <option value="0">*** Select ***</option>
                <?php 
                        $pages = get_pages();
                        foreach ($pages as $item) :
                                if ($anps_page_data['error_page'] == $item->ID) {
                                        $selected = 'selected="selected"';
                                }
                                else {         
                                        $selected = '';
                                }
                ?>      <option value="<?php echo $item->ID; ?>" <?php echo $selected; ?>><?php echo $item->post_title; ?></option>                 
                <?php endforeach; ?>            
        </select>        
        </div>
        <!-- Pagination style -->
        <div class="input">
        <label for="pagination_style">
        <?php _e("Pagination style", ANPS_TEMPLATE_LANG); ?></label>
        <select name="pagination_style">
                <option value="0">*** Select ***</option>
                <?php 
                        $pages = array("style-1"=>"Style 1", "style-2"=>"Style 2");
                        foreach ($pages as $key=>$item) :
                                if ($anps_page_data['pagination_style'] == $key) {
                                        $selected = 'selected="selected"';
                                }
                                else {         
                                        $selected = '';
                                }
                ?>      <option value="<?php echo $key; ?>" <?php echo $selected; ?>><?php echo $item; ?></option>                 
                <?php endforeach; ?>            
        </select>        
        </div>
        <!-- Portfolio single footer -->
        <div class="input">
        <label for="portfolio_single_footer"><?php _e("Portfolio single footer", ANPS_TEMPLATE_LANG); ?></label>
        <?php 
        $value2 = "";
        if(isset($anps_page_data['portfolio_single_footer'])) {
            $value2 = $anps_page_data['portfolio_single_footer']; 
        }
        wp_editor(str_replace('\\"', '"', $value2), 'portfolio_single_footer', array(
                                                                                    'wpautop' => true,                
                                                                                    'media_buttons' => false,                
                                                                                    'textarea_name' => 'portfolio_single_footer',               
                                                                                    'textarea_rows' => 10,                
                                                                                    'teeny' => true )); ?>        
        </div> 
        <hr />
        <!-- Menu -->
        <h3><?php _e("Menu:", ANPS_TEMPLATE_LANG); ?></h3>
        <!-- Sticky menu -->
        <div class="input">
            <?php 
            if(isset($anps_page_data['sticky_menu']) && $anps_page_data['sticky_menu']=="on") {
                $checked='checked';
            } else {
                $checked = '';
            }
            ?>
            <label for="sticky_menu"><?php _e("Sticky menu", ANPS_TEMPLATE_LANG); ?></label>
            <input id="sticky_menu" class="small_input" style="margin-left: 74px" type="checkbox" name="sticky_menu" <?php echo $checked; ?> />
        </div>
        <!-- Menu style -->
        <div class="input">
            <label for="menu_style">
            <?php _e("Menu style (default: menu on background)", ANPS_TEMPLATE_LANG); ?></label>
            <select name="menu_style">
                <option value="0">*** Select ***</option>
                <?php 
                $pages = array(1=>"menu on background", 2=>"menu light", 3=>"menu dark", 4=>"menu light no gradient");
                foreach ($pages as $key=>$item) :
                        if ($anps_page_data['menu_style'] == $key) {
                            $selected = 'selected="selected"';
                        }
                        else {         
                            $selected = '';
                        }
                ?>      
                <option value="<?php echo $key; ?>" <?php echo $selected; ?>><?php echo $item; ?></option>                 
                <?php endforeach; ?>            
            </select>        
        </div>
        <!-- Menu position -->
        <div class="input">
            <label for="menu_position">
            <?php _e("Menu position (default right)", ANPS_TEMPLATE_LANG); ?></label>
            <select name="menu_position">
                <option value="0">*** Select ***</option>
                <?php 
                $pages = array("right"=>"Right", "left"=>"Left");
                foreach ($pages as $key=>$item) :
                        if ($anps_page_data['menu_position'] == $key) {
                            $selected = 'selected="selected"';
                        }
                        else {         
                            $selected = '';
                        }
                ?>      
                <option value="<?php echo $key; ?>" <?php echo $selected; ?>><?php echo $item; ?></option>                 
                <?php endforeach; ?>            
            </select>        
        </div>
        <hr />
        <!-- Footer -->
        <h3><?php _e("Footer:", ANPS_TEMPLATE_LANG); ?></h3>
        <!-- Disable footer -->
        <div class="input">
            <?php
            if(isset($anps_page_data['footer_disable']) && $anps_page_data['footer_disable']=="on") {
                $checked='checked';
            } else {
                $checked = '';
            }
            ?>
            <label for="footer_disable"><?php _e("Disable footer", ANPS_TEMPLATE_LANG); ?></label>
            <input id="footer_disable" class="small_input" style="margin-left: 74px" type="checkbox" name="footer_disable" <?php echo $checked; ?> />
        </div>
        <!-- Footer style -->        
        <div class="input">            
            <label for="footer_style"><?php _e("Footer style", ANPS_TEMPLATE_LANG); ?></label>            
            <select name="footer_style">                
                <option value="0">*** Select ***</option>                
                    <?php $pages = array("2"=>'2 columns', "3" => '3 columns', "4" => '4 columns');                
                    foreach ($pages as $key => $item) :                    
                        if ($anps_page_data['footer_style'] == $key) {                        
                            $selected = 'selected="selected"';                    
                        } else {                         
                            $selected = ''; 
                        } ?>                    
                <option value="<?php echo $key; ?>" <?php echo $selected; ?>><?php echo $item; ?></option>                 
                    <?php endforeach; ?>            
            </select>        
        </div>     
        <!-- Copyright footer -->
        <div class="input">            
            <label for="copyright_footer"><?php _e("Copyright footer", ANPS_TEMPLATE_LANG); ?></label>            
            <select name="copyright_footer">                
                <option value="0">*** Select ***</option>                
                    <?php $pages = array("1"=>'1 column', "2" => '2 columns');                
                    foreach ($pages as $key => $item) :                    
                        if ($anps_page_data['copyright_footer'] == $key) {                        
                            $selected = 'selected="selected"';                    
                        } else {                         
                            $selected = ''; 
                        } ?>                    
                <option value="<?php echo $key; ?>" <?php echo $selected; ?>><?php echo $item; ?></option>                 
                    <?php endforeach; ?>            
            </select>        
        </div> 
        <hr/>
        <h3><?php _e("Visual composer", ANPS_TEMPLATE_LANG); ?></h3>
        <p>Only for backwards compatibility. Do not use on fresh install.</p>
        <!-- Legacy mode -->
        <div class="input onethird">
            <?php
            if(get_option('anps_vc_legacy')=="on") {
                $checked='checked';
            } else {
                $checked = '';
            }
            ?>
            <label for="anps_vc_legacy"><?php _e("Legacy mode", ANPS_TEMPLATE_LANG); ?></label>
            <input id="anps_vc_legacy" class="small_input" style="margin-left: 73px" type="checkbox" name="anps_vc_legacy" <?php echo $checked; ?> />
        </div>
        <!-- END Legacy mode -->
        <div class="clear"></div>
        <hr/>
    </div>    
    <div class="content-top" style="border-style: solid none; margin-top: 70px">        
        <input type="submit" value="<?php _e("Save all changes", ANPS_TEMPLATE_LANG); ?>">        
        <div class="clear"></div>    
    </div>
</form>