<?php
/* Wp title */
add_filter( 'wp_title', 'anps_wp_title_for_home' );
function anps_wp_title_for_home( $title )
{
  // Don't affect wp_title() calls in feeds.
    if (is_feed())
        return $title;
    // The $paged global variable contains the page number of a listing of posts.
    // The $page global variable contains the page number of a single post that is paged.
    // We'll display whichever one applies, if we're not looking at the first page.
    global $paged, $page;
    $separator = "|";
    if (is_search()) {
        // If we're a search, let's start over:
        $title = sprintf(__('Search results for %s', ANPS_TEMPLATE_LANG), '"' . get_search_query() . '"');
        // Add a page number if we're on page 2 or more:
        if ($paged >= 2)
            $title .= " $separator " . sprintf(__('Page %s', ANPS_TEMPLATE_LANG), $paged);
        // Add the site name to the end:
        $title .= " $separator " . get_bloginfo('name', 'display');
        // We're done. Let's send the new title back to wp_title():
        return $title;
    }
    // Otherwise, let's start by adding the site name to the end:
    if(!(is_home() || is_front_page())) {
        $title .= " $separator ";
    }
    $title .= get_bloginfo('name', 'display'); 
    // If we have a site description and we're on the home/front page, add the description:
    $site_description = get_bloginfo('description', 'display');
    if ($site_description && ( is_home() || is_front_page() ))
        $title .= " $separator " . $site_description;
    
    // Add a page number if necessary:
    if ($paged >= 2 || $page >= 2)
        $title .= " $separator " . sprintf(__('Page %s', ANPS_TEMPLATE_LANG), max($paged, $page));
    // Return the new title to wp_title():
    return $title;
}
/* After setup theme */
add_action('after_setup_theme', 'anps_setup');
if (!function_exists('anps_setup')):
    function anps_setup() {
        // This theme styles the visual editor with editor-style.css to match the theme style.
        add_editor_style();
        // This theme uses post thumbnails
        add_theme_support('post-thumbnails');
        // This theme uses wp_nav_menu() in one location.
        register_nav_menus(array(
            'primary' => __('Primary Navigation', ANPS_TEMPLATE_LANG),
        ));
    }
endif;
/* If user is admin, he will see theme options */
add_action('admin_menu', 'anps_theme_options_add_page');
function anps_theme_options_add_page() {
    global $current_user; 
    if($current_user->user_level==10) {
        add_theme_page('Theme Options', 'Theme Options', 'read', 'theme_options', 'anps_theme_options_do_page');
    }
}
function anps_theme_options_do_page() {
    include_once "admin_view.php";
}
/* header */
if (!function_exists('anps_get_header')){
function anps_get_header() {
    global $anps_page_data;
    if(isset($anps_page_data['menu_position']) && $anps_page_data['menu_position']=="left" ) {
        $position_menu = "pull-left";
        $position_logo = "pull-right";
    } else {
        $position_menu = "pull-right";
        $position_logo = "pull-left";
    }
    ?>
    <header class="site-header">
        <div class="container">
          <div class="row">
            <div class="site-logo <?php echo $position_logo; ?>"><?php anps_get_logo(); ?></div>
            <nav role="navigation" class="navbar <?php echo $position_menu; ?>">
                <div class="navbar-header">
                    <button type="button" data-toggle="collapse" data-target=".site-navigation" class="navbar-toggle">
                        <span class="sr-only">Toggle navigation</span>
                        <span class="fa fa-bars"></span>
                    </button>
                </div>
                <?php echo anps_get_menu(); ?>
                <?php
                if ( in_array( 'woocommerce/woocommerce.php', apply_filters( 'active_plugins', get_option( 'active_plugins' ) ) ) ) {
                     anps_woocommerce_header();
                    }
                ?>    
            </nav>   
    
          </div>
        </div>
      </header>
    <?php global $anps_options_data, $anps_shop_data; 
        $disable_single_page = get_post_meta(get_queried_object_id(), $key ='anps_disable_heading', $single = true );
        if(!$disable_single_page=="1") : 
            if(is_front_page()==false && !isset($anps_options_data['disable_heading'])) : 
                global $anps_media_data;
                $style = "";
                $class = "";
                $single_page_bg = get_post_meta(get_queried_object_id(), $key ='heading_bg', $single = true );
                if(is_search()) {
                    if(isset($anps_media_data['search_heading_bg'])) {
                        $style = ' style="background-image: url('.$anps_media_data['search_heading_bg'].');"';
                    } else {
                        $class = "style-2";
                    }
                } else {
                    if($single_page_bg) {
                        $style = ' style="background-image: url('.$single_page_bg.');"'; 
                    }
                    elseif(isset($anps_media_data['heading_bg'])) {
                        $style = ' style="background-image: url('.$anps_media_data['heading_bg'].');"';
                    } else {
                        $class = "style-2";
                    }
                }
                ?>
                <div class='page-heading <?php echo $class; ?>'<?php echo $style; ?>>
                    <div class='container'>
                        <?php if (is_home() && !is_front_page()) { 
                            echo "<h1>".get_the_title(get_option('page_for_posts'))."</h1>";
                        
                        }
                        else if( in_array( 'woocommerce/woocommerce.php', apply_filters( 'active_plugins', get_option( 'active_plugins' ) ) ) && is_shop() ) {
                            echo "<h1>".get_the_title(get_option('woocommerce_shop_page_id'))."</h1>";
                        }
                        else if( in_array( 'woocommerce/woocommerce.php', apply_filters( 'active_plugins', get_option( 'active_plugins' ) ) ) && is_product_category() ) {
                            echo "<h1>".single_cat_title("", false)."</h1>";
                        }
                        else if( in_array( 'woocommerce/woocommerce.php', apply_filters( 'active_plugins', get_option( 'active_plugins' ) ) ) && is_product_tag() ) {
                            echo "<h1>".single_cat_title("", false)."</h1>";
                        }
                        else if( is_archive() ) {
                            if( is_category() ) {
                                $cat = get_category(get_queried_object_id());
                                echo "<h1>".__("Archives for", ANPS_TEMPLATE_LANG) . ' ' . $cat->name . " </h1>";
                            }
                            else if(is_author()) {
                                $author = get_the_author_meta('display_name', $_GET['author']);
                                echo "<h1>".__("Posts by", ANPS_TEMPLATE_LANG) . ' ' . $author .  " </h1>";
                            } elseif(is_tag()) {
                                $cat = get_tag(get_queried_object_id());
                                echo "<h1>".$cat->name . "</h1>";
                            } 
                            else {
                                echo "<h1>".__("Archives for", ANPS_TEMPLATE_LANG) . " " . get_the_date('F') . ' ' . get_the_date('Y')."</h1>";
                            }
                        } elseif(is_search()) {
                            echo "<h1>".__("Search results", ANPS_TEMPLATE_LANG)."</h1>";
                        } elseif(is_404()) {
                            echo "<h1>".__("error 404", ANPS_TEMPLATE_LANG)."</h1>";
                        }
                        else { ?>
                        <h1><?php echo get_the_title(); ?></h1>
                        <?php } ?>
                        <?php if(!isset($anps_options_data['breadcrumbs'])) { echo anps_the_breadcrumb(); } ?>
                    </div>
                </div>
        <?php endif; ?>
    <?php endif; ?>
<?php 
}
}
/* Product categories */
function anps_get_all_product_categories() {
    /* Remove result count and catalog ordering */
    remove_action( 'woocommerce_before_shop_loop', 'woocommerce_catalog_ordering', 30 );
    remove_action( 'woocommerce_before_shop_loop', 'woocommerce_result_count', 20 );
    $args = array(
        'taxonomy' => 'product_cat',
        'orderby' => 'name',
        'order' => 'ASC'
    );
    $shop_class="";
    if(is_shop()) {
        $shop_class = " class='shop-selected'";
    }
    $all_categories = get_categories($args); 
    $data = "<a href='".get_permalink(woocommerce_get_page_id('shop'))."'$shop_class>".__("all", ANPS_TEMPLATE_LANG)."</a>&nbsp;&nbsp;<span class='linkcolor'>•</span>";
    $i=0;
    foreach($all_categories as $item) {
        $shop_class="";
        if($i>0) {
            $data .= "&nbsp;&nbsp;<span class='linkcolor'>•</span>";
        }
        if(is_product_category($item->slug)) {
            $shop_class = " class='shop-selected'";
        }
        $data .= "&nbsp;&nbsp;<a href='".get_term_link($item->slug, 'product_cat')."'$shop_class>".$item->name."</a>";
        $i++;
    }
    return $data;
}
/* Site logo */
function anps_get_logo() { 
    global $anps_media_data; 
    //kličeš $anps_media_data['sticky_logo']
    $logo_width = 160;
    $logo_height = 48;
    if(isset($anps_media_data['logo-width'])) {
        $logo_width = $anps_media_data['logo-width'];
    }
    
    if(isset($anps_media_data['logo-height'])) {
        $logo_height = $anps_media_data['logo-height'];
    } 
    if (isset($anps_media_data['logo']) && $anps_media_data['logo'] != "") : ?>
<a href="<?php echo esc_url(home_url("/")); ?>"><img <?php if(isset($anps_media_data['sticky_logo']) && $anps_media_data['sticky_logo'] != ""){echo "data-sticky='".$anps_media_data['sticky_logo']."'";}?> style="width: <?php echo $logo_width; ?>px; height: <?php echo $logo_height; ?>px" alt="Site logo" src="<?php if(!is_front_page() && isset($anps_media_data['secondary_logo']) && $anps_media_data['secondary_logo'] != "") {echo $anps_media_data['secondary_logo'];} else {echo $anps_media_data['logo'];} ?>"></a>
    <?php else: ?>
        <a href="<?php echo esc_url(home_url("/")); ?>"><img style="width: <?php echo $logo_width; ?>px; height: <?php echo $logo_height; ?>px" alt="Site logo" src="http://anpsthemes.com/kataleya/restaurant/wp-content/uploads/2014/07/logo_head_big1.png"></a>        
    <?php endif;
}
/* remove br tag from shortcodes */
function anps_the_content_filter($content) {
    // array of custom shortcodes requiring the fix 
    $block = join("|",array("accordion", "accordion_item","alert", "anps_reservation", "anps_reservation_item","blog","button", "contact", "form_item", "contact_button","contact_info", "contact_info_item", "dropcaps", "google_maps", "heading", "image","icon", "list", "list_item","mark", "portfolio","pricing_table", "pricing_table_item", "recent_portfolio", "quote", "statement", "tabs", "tab","testimonials", "testimonial","twitter", "vimeo", "youtube"));
    // opening tag
    $rep = preg_replace("/(<p>)?\[($block)(\s[^\]]+)?\](<\/p>|<br \/>)?/","[$2$3]",$content);
    // closing tag
    $rep = preg_replace("/(<p>)?\[\/($block)](<\/p>|<br \/>)?/","[/$2]",$rep);
 
    return $rep;
}
add_filter("the_content", "anps_the_content_filter");
/* body theme classes */
function anps_body_theme_classes($rtn) {
    return anps_is_responsive($rtn).anps_boxed().anps_sticky_menu().anps_is_home().anps_is_woocommerce();
}
/* favicon */
function anps_favicon() {
    global $anps_media_data;

    if (isset($anps_media_data['favicon']) && $anps_media_data['favicon'] != "") : ?>
        <link rel="shortcut icon" href="<?php echo $anps_media_data['favicon']; ?>" type="image/x-icon" />
    <?php endif;
}
/* is home page */
function anps_is_home() {
    global $anps_page_data;
    if((is_front_page())) { 
        if(isset($anps_page_data['menu_style']) && $anps_page_data['menu_style']=="2") {
            return " menu-style-2";
        } elseif(isset($anps_page_data['menu_style']) && $anps_page_data['menu_style']=="3") {
            return " menu-style-2 menu-dark";
        } elseif(isset($anps_page_data['menu_style']) && $anps_page_data['menu_style']=="4") {
            return " menu-style-2 no-gradient";
        } else {
            return "";
        }
    } else {
        return "";
    }
}
/* Google analytics */
function anps_theme_after_styles() {    
    get_template_part("includes/google_analytics");
}

function anps_is_woocommerce() {
if ( in_array( 'woocommerce/woocommerce.php', apply_filters( 'active_plugins', get_option( 'active_plugins' ) ) ) ) {
    return " woocommerce";
    }
    else {
        return "";
    }           
}

/* responsive */
function anps_is_responsive($rtn)  {
    global $anps_options_data;   
    $responsive = "";
    $boxed_backgorund = '';
    $hide_body_class = '';
    if(isset($anps_options_data['preloader']) && $anps_options_data['preloader']=="on") {
        $hide_body_class = ' hide-body';
    }    
    if ( isset($anps_options_data['pattern']) && $anps_options_data['pattern'] && isset($anps_options_data['boxed']) && $anps_options_data['boxed'] == 'on') {
        $boxed_backgorund .= ' pattern-' . $anps_options_data['pattern'];
    }
    if (isset($anps_options_data['responsive'])) $responsive = $anps_options_data['responsive'];
    if ( $responsive != "on" ) {
        if ( $rtn == true ) {
            return " responsive" . $hide_body_class . $boxed_backgorund;
        } else {?>
            <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
        <?php }
    } else {
        return " not-responsive" . $hide_body_class . $boxed_backgorund;
    }    
}
/* boxed */
function anps_boxed() {
    global $anps_options_data;
    if (isset($anps_options_data['boxed']) && $anps_options_data['boxed'] == 'on') {
        return ' boxed';
    }
}
/* sticky menu */
function anps_sticky_menu() { 
    global $anps_page_data;
    if(isset($anps_page_data['sticky_menu']) && $anps_page_data['sticky_menu']=="on") {
        return " sticky-menu";
    }
}
/* Breadcrumbs */ 
function anps_the_breadcrumb() {
    global $anps_page_data;
    $return_val = "<ul>";
    
    $return_val .= '<li><a href="' . home_url() .'">' . __("Home", ANPS_TEMPLATE_LANG) . '</a></li>';
    if (is_home() && !is_front_page()) { 
        $return_val .= "<li>".get_the_title(get_option('page_for_posts'))."</li>";
    } else {
        if( in_array( 'woocommerce/woocommerce.php', apply_filters( 'active_plugins', get_option( 'active_plugins' ) ) ) && is_woocommerce() ) {
            $return_val = "<ul class='breadcrumbs'>";
            ob_start();
            woocommerce_breadcrumb();
            $return_val .= ob_get_clean();
        }
        elseif (is_category() || is_single()) { 
            if (is_single()) { 
                if (get_post_type() != "portfolio" && get_post_type() != "post") { 
                    $return_val .= '<li>' . get_the_title(get_option('page_for_posts')) . '</li>';
                } else { 
                    $custom_breadcrumbs = get_post_meta( get_the_ID(), $key = 'custom_breadcrumbs', $single = true );
                    if($custom_breadcrumbs!="" && $custom_breadcrumbs!="0") { 
                        $return_val .= "<li><a href='".get_permalink($custom_breadcrumbs)."'>".get_the_title($custom_breadcrumbs)."</a></li>";
                    }
                    $return_val .= "<li>".get_the_title()."</li>";
                }
            }
        }
        elseif (is_page()) {  
            $return_val .= "<li>".get_the_title()."</li>";
        } elseif (is_archive()) {
            if (is_author()) {
                $author = get_the_author_meta('display_name', $_GET['author']);
                $return_val .= "<li>" . $author ."</li>";
            } elseif(is_tag()) {
                $cat = get_tag(get_queried_object_id());
                $return_val .= "<li>".$cat->name . "</li>";
            } else {
                $return_val .= "<li>" . __("Archives for", ANPS_TEMPLATE_LANG) . " " . get_the_date('F') . ' ' . get_the_date('Y')."</li>";
            }
        } else {
            if (get_search_query() != "") {
            } else {
                if( isset($anps_page_data['error_page']) && $anps_page_data['error_page'] != '' ) {
                    $page = get_page($anps_page_data['error_page']);
                    $return_val .= "<li>".$page->post_title."</li>";
                }
            }
        }
    }
    if( in_array( 'woocommerce/woocommerce.php', apply_filters( 'active_plugins', get_option( 'active_plugins' ) ) ) && is_woocommerce() ) {

    }
    elseif (single_cat_title("", false) != "" && !is_tag()) {
        $return_val .= "<li>" . single_cat_title("", false)."</li>";
    }
    $return_val .= "</ul>";
    return $return_val;
}
/* Menu */
function anps_get_menu() {
    $locations = get_theme_mod('nav_menu_locations');

    /* Check if menu is selected */
    $walker = '';
    $menu = '';
    $locations = get_theme_mod('nav_menu_locations');

    if($locations && isset($locations['primary']) && $locations['primary']) {
        $menu = $locations['primary'];
        if( (isset($_GET['page']) && $_GET['page'] == 'one-page') ) {
            $menu = 21;
        }
        $walker = new description_walker();
    }

    wp_nav_menu( array(
        'container' => false,
        'menu_class' => 'site-navigation',
        'echo' => true,
        'before' => '',
        'after' => '',
        'link_before' => '',
        'link_after' => '',
        'depth' => 0,
        'walker' => $walker,
        'menu'=>$menu
    ));
}
/* Header image, video, gallery (blog, portfolio) */
function anps_header_media($id, $image_class="") { 
    if(has_post_thumbnail($id)) { 
        $header_media = get_the_post_thumbnail($id, $image_class);
    }
    elseif(get_post_meta($id, $key ='anps_featured_video', $single = true )) { 
        $header_media = do_shortcode(get_post_meta($id, $key ='anps_featured_video', $single = true ));
    }
    else { 
        $header_media = "";
    }
    return $header_media;
}
/* Header image, video, gallery (single blog/portfolio) */
function anps_header_media_single($id, $image_class="") {
    if(has_post_thumbnail($id) && !get_post_meta($id, $key ='gallery_images', $single = true )) { 
        $header_media = get_the_post_thumbnail($id, $image_class);
    }
    elseif(get_post_meta($id, $key ='anps_featured_video', $single = true )) { 
        $header_media = do_shortcode(get_post_meta($id, $key ='anps_featured_video', $single = true ));
    }
    elseif(get_post_meta($id, $key ='gallery_images', $single = true )) { 
        $gallery_images = explode(",",get_post_meta($id, $key ='gallery_images', $single = true )); 
        
        foreach($gallery_images as $key=>$item) {
            if($item == '') {
                unset($gallery_images[$key]);
            }
        }
        $number_images = count($gallery_images);
        $header_media = "";
        $header_media .= "<div id='carousel' class='carousel slide'>";
        if($number_images>"1") {
            $header_media .= "<ol class='carousel-indicators'>";
            for($i=0;$i<count($gallery_images);$i++) {
                if($i==0) {
                    $active_class = "active";
                } else {
                    $active_class = "";
                }
                $header_media .= "<li data-target='#carousel' data-slide-to='".$i."' class='".$active_class."'></li>";
            }
            $header_media .= "</ol>";
        }
        $header_media .= "<div class='carousel-inner'>";
        $j=0;
        foreach($gallery_images as $item) {
            $image_src = wp_get_attachment_image_src($item, $image_class); 
            $image_title = get_the_title($item); 
            if($j==0) {
                $active_class = " active";
            } else {
                $active_class = "";
            }
            $header_media .= "<div class='item$active_class'>";
            $header_media .= "<img alt='".$image_title."'  src='".$image_src[0]."'>";
            $header_media .= "</div>";
            $j++;
        }
        $header_media .= "</div>";
        if($number_images>"1") {
            $header_media .= "<a class='left carousel-control' href='#carousel' data-slide='prev'>
                                <span class='fa fa-chevron-left'></span>
                              </a>
                              <a class='right carousel-control' href='#carousel' data-slide='next'>
                                <span class='fa fa-chevron-right'></span>
                              </a>";
                      
        }
        $header_media .= "</div>";
    }
    else { 
        $header_media = "";
    }
    return $header_media;
}
/* Comments */
function anps_comment($comment, $args, $depth) {
    $email = $comment->comment_author_email;
    $user_id = -1;
    if (email_exists($email)) {
        $user_id = email_exists($email);
    }
    $GLOBALS['comment'] = $comment; 
    ?>  
    <li <?php comment_class(); ?>>
        <article id="comment-<?php comment_ID(); ?>">
            <header>
                <?php echo get_avatar($user_id, 116); ?>
                <h5><?php comment_author(); ?></h5> 
                <span class="date"><?php echo get_comment_date("d.m.Y"); ?></span>
                <?php echo comment_reply_link(array_merge(array('reply_text' => 'Reply'), array('depth' => $depth, 'max_depth' => $args['max_depth']))); ?>
            </header>
            <?php comment_text(); ?>
        </article>
<?php }
/* END Comments */
/* Add class next/previous portfolio link */
add_filter('previous_post_link', 'anps_posts_link_attributes');
add_filter('next_post_link', 'anps_posts_link_attributes');
function anps_posts_link_attributes($format) {
    $format = str_replace('href=', 'class="btn btn-md" href=', $format);
    return $format;
}
/* END Add class next/previous portfolio link */
/* Override vc tabs */
include_once( ABSPATH . 'wp-admin/includes/plugin.php' );
if ( is_plugin_active( 'js_composer/js_composer.php' ) && get_option('anps_vc_legacy', "0")=="on") {
    function vc_theme_rows($atts, $content) {
        $extra_class = '';
        $extra_id = '';
        $matches = array();

        global $no_container, $row_inner, $text_only;

        if ( $row_inner ) {
            return vc_theme_rows_inner($atts, $content);
        }

        if ( $text_only ) {
            return wpb_js_remove_wpautop($content);
        }

        /* Check for any user added styles */

        $css = '';
        if( isset($atts['css']) ) {
            $css = $atts['css'];
        }

        $temp = preg_match('/\.vc_custom_(.*?){/s', $css, $matches);
        if(!empty($matches)) {
            $temp = $matches[1];

            if( $temp ) {
                $extra_class .= ' vc_custom_' . $temp;
            }
        }

        /* Check for any user added classes */

        if(isset($atts['el_class']) && $atts['el_class']) {
            $extra_class .= ' '. $atts['el_class'];
        }

        /* Check for any user added IDs */

        if(isset($atts['id']) && $atts['id']) {
            $extra_id = 'id= "'. $atts['id'].'"';
        }

        global $anps_page_data, $single_portfolio;

        if((!isset($anps_page_data['coming_soon']) || $anps_page_data['coming_soon']=="0")||is_super_admin()) { 
            if(!isset($atts['has_content']) || $atts['has_content']=="true") {
                /* Content inside a container */
                $no_container = false;
                $no_top_margin = '';
                if( strpos($extra_class, 'no-top-margin') ) {
                    $no_top_margin = ' no-top-margin';
                }
                $container_class = "";
                if(!isset($single_portfolio)) {
                    $container_class = "container";
                }
                return '<section class="' . $container_class.$no_top_margin . $extra_class.'"><div '.$extra_id.' class="row">'.wpb_js_remove_wpautop($content).'</div></section>';
            } 
            elseif($atts['has_content']=="inside") {
                $no_container = false;
                return '<section '.$extra_id.' class="' . $extra_class . '"><div class="container no-margin"><div class="row">'.wpb_js_remove_wpautop($content).'</div></div></section>';
            }
            else {
                /* Fullwidth Content */
                $no_container = false;
                $no_container = true;
                return '<section '.$extra_id.' class="' . $extra_class . '">'.wpb_js_remove_wpautop($content).'</section>';
                //return '<div '.$extra_id.' class="no-margin' . $extra_class . '">'.wpb_js_remove_wpautop($content).'</div>';
                //return wpb_js_remove_wpautop($content);
            }
        } else { 
            /* No wrappers, only when Cooming soon is active */
            $no_container = true;
            return wpb_js_remove_wpautop($content);
        }
    }
    function vc_theme_rows_inner($atts, $content) {

        /* Check for any user added styles */

        $style = "";
        $css = '';

        if( isset($atts['css']) ) {
            $css = $atts['css'];
        }

        $temp = preg_match('/{(.*?)}/s', $css, $matches);
        if(!empty($matches)) {
            $temp = $matches[1];
            if( $temp ) {
                $style = ' style="' . $temp . '"';
            }
        }

        return '<div class="row"' . $style . '>'.wpb_js_remove_wpautop($content).'</div>';
    }
    function vc_theme_columns($atts, $content = null) { 
        if( !isset($atts['width']) ) {
            $width = '1/1';
        } else {
            $width = explode('/', $atts['width']); 
        }

        global $no_container, $text_only;
        $extra_id = '';
        $extra_class = '';
        if($width[1] > 0) {
            $col = (12/$width[1])*$width[0];
        } else {
            $col = 12;
        }
        $css = '';
        if( isset($atts['css']) ) {
            $css = $atts['css'];
        }
        
        $temp = preg_match('/\.vc_custom_(.*?){/s', $css, $matches);
        if(!empty($matches)) {
            $temp = $matches[1];

            if( $temp ) {
                $extra_class .= ' vc_custom_' . $temp;
            }
        }
        $mobile_class = "";
        if(isset($atts['offset']) && $atts['offset']) {
            $mobile_class = " ".$atts['offset'];
        }
        
        if(isset($atts['el_class']) && $atts['el_class']) {
            $extra_class = ' ' . $atts['el_class'];
        }
      
        if(isset($atts['id']) && $atts['id']) {
            $extra_id = 'id= "'. $atts['id'].'"';
        }

        if ( $no_container || $text_only ) { 
            return "<div class='$mobile_class'>".wpb_js_remove_wpautop($content)."</div>";
        } else { 
            return '<div '.$extra_id.' class="wpb_column col-md-' .$col.$extra_class.$mobile_class.'">'.wpb_js_remove_wpautop($content).'</div>';
        }
    }
    function vc_theme_vc_row($atts, $content = null) {
        return vc_theme_rows($atts, $content);
    }
    function vc_theme_vc_row_inner($atts, $content = null) {
        return vc_theme_rows_inner($atts, $content);
    }
    function vc_theme_vc_column($atts, $content = null) {
        return vc_theme_columns($atts, $content);
    }
    function vc_theme_vc_column_inner($atts, $content = null) {
        return vc_theme_columns($atts, $content);
    }
    function vc_theme_vc_tabs($atts, $content = null) { 
        $content2 = str_replace("vc_tab", "tab", $content);
        if(!isset($atts['type'])) {
            $atts['type'] = "";
        } else {
            $atts['type'] = $atts['type'];
        }
        return do_shortcode("[tabs type='".$atts['type']."']".$content2."[/tabs]");
    }
    function vc_theme_vc_column_text($atts, $content = null) {
        $extra_class = '';

        /* Check for any user added styles */

        $css = '';
        if( isset($atts['css']) ) {
            $css = $atts['css'];
        }

        $temp = preg_match('/\.vc_custom_(.*?){/s', $css, $matches);
        if(!empty($matches)) {
            $temp = $matches[1];

            if( $temp ) {
                $extra_class .= ' vc_custom_' . $temp;
            }
        }

        return '<div class="text' . $extra_class . '">' . do_shortcode(force_balance_tags($content)) . '</div>';
    }
}
/* hide sidebar generator on testimonials and portfolio */
if (anps_get_current_post_type() != 'product' && anps_get_current_post_type() != 'testimonials' && anps_get_current_post_type() != 'portfolio' && anps_get_current_post_type() != 'menu' && anps_get_current_post_type() != 'orders' && anps_get_current_post_type() != 'reservation' && anps_get_current_post_type() != 'courses') {
    //add sidebar generator
    include_once 'sidebar_generator.php';
}
//get post_type    
function anps_get_current_post_type() {
    if (is_admin()) {
        global $post, $typenow, $current_screen;
        //we have a post so we can just get the post type from that
        if ($post && $post->post_type)
            return $post->post_type;
        //check the global $typenow - set in admin.php
        elseif ($typenow)
            return $typenow;
        //check the global $current_screen object - set in sceen.php
        elseif ($current_screen && $current_screen->post_type)
            return $current_screen->post_type;
        //lastly check the post_type querystring
        elseif (isset($_REQUEST['post_type']))
            return sanitize_key($_REQUEST['post_type']);
        elseif (isset($_REQUEST['post']))
            return get_post_type($_REQUEST['post']);
        //we do not know the post type!
        return null;
    }
}